%SEPIA  Black-brown-white colormap
%
% Examples:
%   map = sepia;
%   map = sepia(len);
%   B = sepia(A);
%   B = sepia(A, lims);
%
% A colormap designed to replicate the sepia tones of old photographs, as
% well as achieve perceptual uniformity.
%
% The function can additionally be used to convert a real-valued array into
% a truecolor array using the colormap.
%
% IN:
%   len - Scalar length of the output colormap. If len == Inf the concise
%         table is returned. Default: len = size(get(gcf, 'Colormap'), 1);
%   A - Non-scalar numeric array of real values to be converted into
%       truecolor.
%   lims - 1x2 array of saturation limits to be used on A. Default:
%          [min(A(:)) max(A(:))].
%
% OUT:
%   map - (len)x3 colormap table of RGB values in the range [0,1].
%   B - size(A)x3 truecolor array.

% Copyright: Oliver Woodford, 2009, 2015

function map = sepia(varargin)
map = [     0         0         0
       0.0072    0.0052    0.0043
       0.0146    0.0104    0.0086
       0.0218    0.0158    0.0132
       0.0290    0.0210    0.0175
       0.0364    0.0262    0.0218
       0.0434    0.0314    0.0261
       0.0500    0.0368    0.0305
       0.0560    0.0420    0.0350
       0.0615    0.0468    0.0393
       0.0668    0.0513    0.0434
       0.0718    0.0556    0.0474
       0.0764    0.0598    0.0512
       0.0809    0.0637    0.0548
       0.0851    0.0674    0.0582
       0.0892    0.0710    0.0615
       0.0931    0.0744    0.0647
       0.0969    0.0776    0.0678
       0.1005    0.0809    0.0707
       0.1041    0.0840    0.0736
       0.1076    0.0870    0.0762
       0.1112    0.0898    0.0789
       0.1149    0.0926    0.0816
       0.1187    0.0955    0.0841
       0.1225    0.0983    0.0864
       0.1264    0.1011    0.0888
       0.1303    0.1040    0.0911
       0.1341    0.1069    0.0933
       0.1380    0.1098    0.0956
       0.1419    0.1127    0.0979
       0.1458    0.1156    0.1002
       0.1497    0.1185    0.1025
       0.1536    0.1214    0.1047
       0.1576    0.1243    0.1071
       0.1616    0.1273    0.1094
       0.1655    0.1303    0.1117
       0.1695    0.1332    0.1140
       0.1735    0.1362    0.1164
       0.1776    0.1392    0.1187
       0.1815    0.1422    0.1210
       0.1856    0.1452    0.1233
       0.1897    0.1482    0.1257
       0.1937    0.1512    0.1281
       0.1977    0.1543    0.1304
       0.2017    0.1573    0.1327
       0.2058    0.1604    0.1350
       0.2098    0.1635    0.1374
       0.2139    0.1666    0.1397
       0.2180    0.1697    0.1421
       0.2220    0.1728    0.1444
       0.2261    0.1759    0.1467
       0.2302    0.1791    0.1491
       0.2343    0.1822    0.1514
       0.2383    0.1854    0.1538
       0.2424    0.1886    0.1562
       0.2466    0.1918    0.1585
       0.2507    0.1950    0.1609
       0.2548    0.1981    0.1633
       0.2590    0.2013    0.1656
       0.2631    0.2046    0.1680
       0.2673    0.2078    0.1704
       0.2714    0.2110    0.1727
       0.2756    0.2143    0.1751
       0.2798    0.2175    0.1775
       0.2840    0.2208    0.1799
       0.2882    0.2240    0.1823
       0.2924    0.2273    0.1847
       0.2966    0.2306    0.1871
       0.3007    0.2339    0.1894
       0.3049    0.2373    0.1918
       0.3091    0.2406    0.1942
       0.3132    0.2439    0.1966
       0.3174    0.2473    0.1990
       0.3216    0.2506    0.2014
       0.3258    0.2540    0.2038
       0.3301    0.2574    0.2062
       0.3343    0.2608    0.2086
       0.3386    0.2641    0.2110
       0.3429    0.2675    0.2134
       0.3471    0.2709    0.2159
       0.3514    0.2743    0.2183
       0.3557    0.2777    0.2208
       0.3600    0.2811    0.2232
       0.3643    0.2846    0.2256
       0.3686    0.2880    0.2281
       0.3728    0.2915    0.2305
       0.3771    0.2949    0.2329
       0.3814    0.2984    0.2354
       0.3857    0.3019    0.2378
       0.3900    0.3054    0.2403
       0.3944    0.3089    0.2427
       0.3987    0.3123    0.2452
       0.4031    0.3159    0.2477
       0.4074    0.3194    0.2501
       0.4118    0.3229    0.2526
       0.4162    0.3264    0.2551
       0.4206    0.3299    0.2576
       0.4250    0.3335    0.2601
       0.4293    0.3370    0.2625
       0.4337    0.3405    0.2650
       0.4381    0.3441    0.2675
       0.4426    0.3477    0.2700
       0.4470    0.3512    0.2725
       0.4514    0.3548    0.2750
       0.4558    0.3584    0.2775
       0.4602    0.3620    0.2800
       0.4647    0.3656    0.2826
       0.4691    0.3692    0.2851
       0.4732    0.3729    0.2876
       0.4773    0.3767    0.2901
       0.4814    0.3805    0.2926
       0.4855    0.3843    0.2951
       0.4896    0.3881    0.2976
       0.4937    0.3919    0.3001
       0.4978    0.3957    0.3026
       0.5019    0.3994    0.3052
       0.5060    0.4033    0.3077
       0.5102    0.4071    0.3102
       0.5143    0.4109    0.3128
       0.5185    0.4147    0.3153
       0.5226    0.4186    0.3178
       0.5268    0.4224    0.3204
       0.5309    0.4263    0.3230
       0.5350    0.4301    0.3255
       0.5385    0.4342    0.3289
       0.5415    0.4384    0.3329
       0.5446    0.4426    0.3369
       0.5476    0.4469    0.3409
       0.5506    0.4511    0.3449
       0.5536    0.4553    0.3489
       0.5567    0.4596    0.3530
       0.5597    0.4638    0.3570
       0.5627    0.4680    0.3609
       0.5658    0.4723    0.3646
       0.5689    0.4766    0.3683
       0.5720    0.4808    0.3719
       0.5750    0.4851    0.3756
       0.5781    0.4894    0.3792
       0.5812    0.4937    0.3830
       0.5842    0.4980    0.3868
       0.5873    0.5023    0.3908
       0.5909    0.5063    0.3957
       0.5946    0.5103    0.4006
       0.5981    0.5144    0.4055
       0.6017    0.5184    0.4104
       0.6052    0.5225    0.4153
       0.6088    0.5266    0.4203
       0.6124    0.5306    0.4252
       0.6160    0.5347    0.4302
       0.6193    0.5389    0.4350
       0.6225    0.5431    0.4398
       0.6257    0.5474    0.4446
       0.6286    0.5517    0.4491
       0.6321    0.5558    0.4542
       0.6351    0.5602    0.4588
       0.6383    0.5645    0.4636
       0.6414    0.5687    0.4684
       0.6446    0.5730    0.4732
       0.6479    0.5773    0.4781
       0.6511    0.5816    0.4829
       0.6542    0.5859    0.4878
       0.6575    0.5901    0.4927
       0.6606    0.5944    0.4975
       0.6638    0.5987    0.5024
       0.6670    0.6030    0.5073
       0.6706    0.6072    0.5124
       0.6745    0.6113    0.5175
       0.6784    0.6153    0.5226
       0.6823    0.6194    0.5278
       0.6862    0.6235    0.5329
       0.6902    0.6276    0.5381
       0.6941    0.6316    0.5433
       0.6981    0.6357    0.5484
       0.7021    0.6397    0.5536
       0.7065    0.6437    0.5586
       0.7109    0.6476    0.5637
       0.7153    0.6516    0.5688
       0.7197    0.6556    0.5739
       0.7241    0.6596    0.5790
       0.7285    0.6635    0.5841
       0.7328    0.6675    0.5892
       0.7372    0.6715    0.5944
       0.7414    0.6756    0.5996
       0.7455    0.6797    0.6049
       0.7497    0.6837    0.6101
       0.7539    0.6878    0.6154
       0.7580    0.6919    0.6207
       0.7622    0.6960    0.6259
       0.7664    0.7001    0.6312
       0.7705    0.7042    0.6365
       0.7744    0.7084    0.6419
       0.7782    0.7126    0.6473
       0.7820    0.7168    0.6528
       0.7858    0.7210    0.6582
       0.7896    0.7253    0.6636
       0.7934    0.7295    0.6691
       0.7972    0.7338    0.6745
       0.8011    0.7380    0.6800
       0.8048    0.7423    0.6854
       0.8084    0.7466    0.6908
       0.8120    0.7510    0.6962
       0.8156    0.7553    0.7016
       0.8192    0.7596    0.7071
       0.8229    0.7640    0.7125
       0.8265    0.7683    0.7180
       0.8301    0.7727    0.7234
       0.8337    0.7771    0.7289
       0.8372    0.7815    0.7343
       0.8407    0.7859    0.7397
       0.8442    0.7903    0.7451
       0.8477    0.7947    0.7506
       0.8512    0.7991    0.7560
       0.8547    0.8036    0.7615
       0.8582    0.8080    0.7669
       0.8617    0.8125    0.7724
       0.8651    0.8169    0.7778
       0.8686    0.8214    0.7833
       0.8720    0.8259    0.7887
       0.8755    0.8303    0.7942
       0.8789    0.8348    0.7997
       0.8823    0.8393    0.8051
       0.8858    0.8438    0.8106
       0.8892    0.8483    0.8161
       0.8926    0.8528    0.8216
       0.8960    0.8573    0.8271
       0.8994    0.8619    0.8326
       0.9028    0.8664    0.8381
       0.9062    0.8709    0.8436
       0.9096    0.8755    0.8491
       0.9130    0.8800    0.8546
       0.9164    0.8846    0.8601
       0.9198    0.8891    0.8656
       0.9231    0.8937    0.8712
       0.9265    0.8983    0.8767
       0.9299    0.9028    0.8822
       0.9332    0.9074    0.8878
       0.9366    0.9120    0.8933
       0.9400    0.9166    0.8989
       0.9433    0.9212    0.9044
       0.9467    0.9258    0.9100
       0.9500    0.9304    0.9156
       0.9534    0.9350    0.9212
       0.9567    0.9396    0.9268
       0.9600    0.9442    0.9324
       0.9634    0.9488    0.9380
       0.9667    0.9535    0.9436
       0.9701    0.9581    0.9492
       0.9734    0.9627    0.9548
       0.9767    0.9674    0.9604
       0.9801    0.9720    0.9661
       0.9834    0.9767    0.9717
       0.9867    0.9813    0.9774
       0.9900    0.9860    0.9830
       0.9934    0.9907    0.9887
       0.9967    0.9953    0.9943
       1         1         1];
map = colormap_helper(map, varargin{:});
