%HSV2  Black to red variation of the hsv colormap
%
% Examples:
%   map = hsv2;
%   map = hsv2(len);
%   B = hsv2(A);
%   B = hsv2(A, lims);
%
% A variation of MATLAB's hsv colormap, which starts in black.
%
% The function can additionally be used to convert a real-valued array into
% a truecolor array using the colormap.
%
% IN:
%   len - Scalar length of the output colormap. If len == Inf the concise
%         table is returned. Default: len = size(get(gcf, 'Colormap'), 1);
%   A - Non-scalar numeric array of real values to be converted into
%       truecolor.
%   lims - 1x2 array of saturation limits to be used on A. Default:
%          [min(A(:)) max(A(:))].
%
% OUT:
%   map - (len)x3 colormap table.
%   B - size(A)x3 truecolor array.

% Copyright: Oliver Woodford, 2009

function map = hsv2(varargin)
map = [0 0 0; 0.5 0 0.5; 0 0 0.9; 0 1 1; 0 1 0; 1 1 0; 1 0 0];
map = colormap_helper(map, varargin{:});