%DUSK  Black-purple-blue-green-red-yellow-white colormap
%
% Examples:
%   map = dusk;
%   map = dusk(len);
%   B = dusk(A);
%   B = dusk(A, lims);
%
% A black to white colormap with several distinct pastel shades reminiscent
% of colors at dusk. This colormap has been designed to achieve perceptual
% uniformity.
%
% The function can additionally be used to convert a real-valued array into
% a truecolor array using the colormap.
%
% IN:
%   len - Scalar length of the output colormap. If len == Inf the concise
%         table is returned. Default: len = size(get(gcf, 'Colormap'), 1);
%   A - Non-scalar numeric array of real values to be converted into
%       truecolor.
%   lims - 1x2 array of saturation limits to be used on A. Default:
%          [min(A(:)) max(A(:))].
%
% OUT:
%   map - (len)x3 colormap table of RGB values in the range [0,1].
%   B - size(A)x3 truecolor array.

% Copyright: Oliver Woodford, 2009, 2015

function map = dusk(varargin)
map = [     0         0         0
       0.0077    0.0040    0.0152
       0.0156    0.0079    0.0303
       0.0234    0.0121    0.0453
       0.0311    0.0160    0.0580
       0.0394    0.0199    0.0690
       0.0470    0.0238    0.0786
       0.0539    0.0277    0.0875
       0.0604    0.0315    0.0956
       0.0662    0.0356    0.1032
       0.0714    0.0395    0.1109
       0.0758    0.0433    0.1187
       0.0796    0.0471    0.1265
       0.0830    0.0507    0.1345
       0.0859    0.0541    0.1425
       0.0884    0.0574    0.1506
       0.0910    0.0605    0.1587
       0.0937    0.0632    0.1669
       0.0967    0.0655    0.1751
       0.0999    0.0677    0.1834
       0.1033    0.0695    0.1917
       0.1068    0.0711    0.2000
       0.1104    0.0726    0.2085
       0.1139    0.0742    0.2169
       0.1176    0.0756    0.2253
       0.1213    0.0770    0.2338
       0.1252    0.0784    0.2422
       0.1292    0.0798    0.2506
       0.1333    0.0811    0.2591
       0.1375    0.0823    0.2675
       0.1414    0.0836    0.2761
       0.1454    0.0848    0.2847
       0.1494    0.0860    0.2933
       0.1536    0.0872    0.3020
       0.1580    0.0882    0.3106
       0.1625    0.0892    0.3191
       0.1672    0.0901    0.3276
       0.1719    0.0909    0.3362
       0.1769    0.0917    0.3447
       0.1820    0.0923    0.3532
       0.1873    0.0928    0.3616
       0.1927    0.0931    0.3701
       0.1973    0.0939    0.3789
       0.2017    0.0947    0.3879
       0.2060    0.0955    0.3969
       0.2101    0.0964    0.4061
       0.2138    0.0975    0.4155
       0.2171    0.0987    0.4250
       0.2198    0.1002    0.4348
       0.2221    0.1018    0.4447
       0.2198    0.1060    0.4556
       0.2148    0.1116    0.4666
       0.2088    0.1173    0.4776
       0.2016    0.1234    0.4885
       0.1932    0.1297    0.4993
       0.1832    0.1362    0.5100
       0.1717    0.1429    0.5204
       0.1583    0.1498    0.5307
       0.1432    0.1571    0.5391
       0.1293    0.1648    0.5446
       0.1143    0.1723    0.5496
       0.0983    0.1795    0.5541
       0.0810    0.1866    0.5582
       0.0614    0.1934    0.5618
       0.0381    0.2000    0.5650
       0.0127    0.2066    0.5680
            0    0.2129    0.5704
            0    0.2189    0.5718
            0    0.2247    0.5731
            0    0.2305    0.5742
            0    0.2363    0.5752
            0    0.2420    0.5764
            0    0.2476    0.5774
            0    0.2533    0.5784
            0    0.2588    0.5793
            0    0.2643    0.5798
            0    0.2697    0.5803
            0    0.2750    0.5807
            0    0.2804    0.5811
            0    0.2857    0.5816
            0    0.2911    0.5820
            0    0.2964    0.5825
            0    0.3017    0.5829
            0    0.3069    0.5829
            0    0.3120    0.5828
            0    0.3171    0.5827
            0    0.3223    0.5826
            0    0.3274    0.5825
            0    0.3325    0.5824
            0    0.3377    0.5823
            0    0.3428    0.5822
            0    0.3478    0.5817
            0    0.3527    0.5808
            0    0.3576    0.5800
            0    0.3625    0.5791
            0    0.3675    0.5782
            0    0.3724    0.5773
            0    0.3773    0.5764
            0    0.3822    0.5755
            0    0.3870    0.5743
            0    0.3916    0.5722
            0    0.3962    0.5701
            0    0.4007    0.5680
            0    0.4052    0.5658
            0    0.4098    0.5636
            0    0.4143    0.5612
            0    0.4188    0.5588
            0    0.4232    0.5563
            0    0.4270    0.5528
            0    0.4308    0.5493
       0.0311    0.4346    0.5458
       0.0736    0.4383    0.5421
       0.1039    0.4420    0.5385
       0.1290    0.4455    0.5348
       0.1512    0.4490    0.5311
       0.1714    0.4525    0.5274
       0.1953    0.4552    0.5245
       0.2178    0.4578    0.5218
       0.2386    0.4603    0.5194
       0.2582    0.4627    0.5171
       0.2769    0.4650    0.5151
       0.2947    0.4672    0.5134
       0.3119    0.4694    0.5118
       0.3285    0.4715    0.5105
       0.3446    0.4735    0.5095
       0.3603    0.4755    0.5087
       0.3757    0.4774    0.5082
       0.3906    0.4792    0.5079
       0.4053    0.4810    0.5079
       0.4197    0.4827    0.5081
       0.4339    0.4844    0.5085
       0.4478    0.4860    0.5092
       0.4615    0.4875    0.5100
       0.4750    0.4890    0.5110
       0.4884    0.4904    0.5121
       0.5016    0.4918    0.5135
       0.5147    0.4932    0.5148
       0.5277    0.4945    0.5161
       0.5405    0.4958    0.5175
       0.5533    0.4970    0.5190
       0.5659    0.4982    0.5205
       0.5785    0.4994    0.5220
       0.5910    0.5005    0.5235
       0.6034    0.5016    0.5249
       0.6158    0.5027    0.5264
       0.6281    0.5037    0.5278
       0.6403    0.5047    0.5292
       0.6525    0.5056    0.5305
       0.6647    0.5065    0.5317
       0.6768    0.5074    0.5329
       0.6888    0.5083    0.5340
       0.7008    0.5092    0.5349
       0.7128    0.5100    0.5357
       0.7247    0.5108    0.5364
       0.7365    0.5116    0.5369
       0.7483    0.5124    0.5372
       0.7599    0.5133    0.5373
       0.7716    0.5141    0.5372
       0.7831    0.5149    0.5369
       0.7945    0.5158    0.5364
       0.8058    0.5167    0.5357
       0.8170    0.5177    0.5347
       0.8280    0.5187    0.5335
       0.8389    0.5197    0.5322
       0.8497    0.5209    0.5305
       0.8602    0.5222    0.5285
       0.8703    0.5237    0.5260
       0.8803    0.5253    0.5234
       0.8901    0.5270    0.5205
       0.8996    0.5289    0.5175
       0.9089    0.5308    0.5143
       0.9180    0.5329    0.5110
       0.9269    0.5351    0.5075
       0.9347    0.5381    0.5036
       0.9388    0.5432    0.4996
       0.9428    0.5484    0.4957
       0.9466    0.5537    0.4918
       0.9501    0.5592    0.4880
       0.9536    0.5647    0.4842
       0.9568    0.5702    0.4805
       0.9599    0.5759    0.4767
       0.9629    0.5816    0.4730
       0.9637    0.5884    0.4711
       0.9644    0.5952    0.4691
       0.9650    0.6020    0.4672
       0.9655    0.6088    0.4654
       0.9661    0.6155    0.4634
       0.9666    0.6223    0.4615
       0.9670    0.6291    0.4597
       0.9673    0.6359    0.4579
       0.9674    0.6427    0.4564
       0.9673    0.6496    0.4551
       0.9671    0.6565    0.4538
       0.9668    0.6634    0.4526
       0.9664    0.6703    0.4515
       0.9659    0.6773    0.4505
       0.9652    0.6842    0.4496
       0.9645    0.6911    0.4488
       0.9637    0.6981    0.4482
       0.9626    0.7051    0.4478
       0.9615    0.7121    0.4476
       0.9602    0.7191    0.4474
       0.9589    0.7261    0.4475
       0.9574    0.7331    0.4477
       0.9558    0.7401    0.4480
       0.9540    0.7471    0.4486
       0.9520    0.7542    0.4498
       0.9494    0.7613    0.4522
       0.9468    0.7685    0.4548
       0.9441    0.7756    0.4576
       0.9412    0.7828    0.4608
       0.9382    0.7899    0.4643
       0.9351    0.7970    0.4680
       0.9318    0.8041    0.4721
       0.9285    0.8112    0.4771
       0.9267    0.8173    0.4883
       0.9250    0.8234    0.4995
       0.9233    0.8294    0.5109
       0.9219    0.8353    0.5225
       0.9206    0.8412    0.5344
       0.9194    0.8469    0.5464
       0.9184    0.8526    0.5585
       0.9174    0.8582    0.5708
       0.9177    0.8634    0.5836
       0.9182    0.8685    0.5965
       0.9188    0.8735    0.6094
       0.9196    0.8784    0.6224
       0.9205    0.8833    0.6354
       0.9216    0.8881    0.6484
       0.9228    0.8929    0.6615
       0.9242    0.8976    0.6746
       0.9260    0.9021    0.6876
       0.9280    0.9066    0.7007
       0.9302    0.9110    0.7138
       0.9325    0.9154    0.7269
       0.9349    0.9197    0.7400
       0.9374    0.9240    0.7530
       0.9400    0.9283    0.7661
       0.9427    0.9325    0.7791
       0.9455    0.9367    0.7922
       0.9486    0.9408    0.8052
       0.9518    0.9449    0.8182
       0.9550    0.9489    0.8312
       0.9583    0.9529    0.8441
       0.9616    0.9569    0.8571
       0.9649    0.9609    0.8701
       0.9683    0.9649    0.8831
       0.9718    0.9688    0.8960
       0.9753    0.9728    0.9090
       0.9788    0.9767    0.9220
       0.9824    0.9806    0.9350
       0.9860    0.9844    0.9480
       0.9894    0.9884    0.9610
       0.9929    0.9923    0.9740
       0.9965    0.9961    0.9870
            1         1         1];
map = colormap_helper(map, varargin{:});