%DISCO  High contrast colormap with strong gradient discontinuities
%
% Examples:
%   map = disco;
%   map = disco(len);
%   B = disco(A);
%   B = disco(A, lims);
%
% A colormap designed to highlight contours. It has strong gradient
% discontinuities, and maximizes the range of colors used in order to  
% improve contrast between intensity levels. It converts linearly to
% grayscale, such that black & white prints come out nicely.
%
% The function can additionally be used to convert a real valued array into
% a truecolor array using the colormap.
%
% IN:
%   len - Scalar length of the output colormap. If len == Inf the concise
%         table is returned. Default: len = size(get(gcf, 'Colormap'), 1);
%   A - Non-scalar numeric array of real values to be converted into
%       truecolor.
%   lims - 1x2 array of saturation limits to be used on A. Default:
%          [min(A(:)) max(A(:))].
%
% OUT:
%   map - (len)xJ colormap table. J = 3, except in the concise case, when
%         J = 4, map(1:end-1,4) giving the relative sizes of the 
%         inter-color bins.
%   B - size(A)x3 truecolor array.

% Copyright: Oliver Woodford, 2012

function map = disco(varargin)
map = [            0                   0                   0   1.000000000000000; ...
                   0                   0   0.548245614035088                   0; ...
                   0   0.106473594548552                   0   1.000000000000000; ...
   0.418060200668896                   0                   0                   0; ...
                   0   0.212947189097104                   0   1.000000000000000; ...
   0.627090301003345                   0                   0                   0; ...
                   0   0.319420783645656                   0   1.000000000000000; ...
   0.836120401337793                   0                   0                   0; ...
                   0   0.425894378194208                   0   1.000000000000000; ...
   1.000000000000000                   0   0.118421052631579                   0; ...
                   0   0.532367972742760                   0   1.000000000000000; ...
   1.000000000000000                   0   0.666666666666667                   0; ...
                   0   0.638841567291312                   0   1.000000000000000; ...
   1.000000000000000   0.041737649063032   1.000000000000000                   0; ...
                   0   0.745315161839864                   0   1.000000000000000; ...
   1.000000000000000   0.148211243611584   1.000000000000000                   0; ...
                   0   0.851788756388416                   0   1.000000000000000; ...
   1.000000000000000   0.254684838160136   1.000000000000000                   0; ...
                   0   0.958262350936968                   0   1.000000000000000; ...
   1.000000000000000   0.361158432708688   1.000000000000000                   0; ...
                   0   1.000000000000000   0.333333333333334   1.000000000000000; ...
   1.000000000000000   0.467632027257240   1.000000000000000                   0; ...
                   0   1.000000000000000   0.881578947368421   1.000000000000000; ...
   1.000000000000000   0.574105621805792   1.000000000000000                   0; ...
   0.163879598662207   1.000000000000000   1.000000000000000   1.000000000000000; ...
   1.000000000000000   0.680579216354344   1.000000000000000                   0; ...
   0.372909698996656   1.000000000000000   1.000000000000000   1.000000000000000; ...
   1.000000000000000   0.981260647359455                   0                   0; ...
   0.581939799331104   1.000000000000000   1.000000000000000   1.000000000000000; ...
   1.000000000000000   1.000000000000000   0.451754385964913                   0; ...
   0.790969899665552   1.000000000000000   1.000000000000000   1.000000000000000; ...
   1.000000000000000   1.000000000000000   1.000000000000000                   0];
map = colormap_helper(map, varargin{:});