%DAWN  Black-purple-blue-green-yellow-white colormap
%
% Examples:
%   map = dawn;
%   map = dawn(len);
%   B = dawn(A);
%   B = dawn(A, lims);
%
% A black to white colormap with several distinct pastel shades reminiscent
% of colors at dawn. This colormap has been designed to achieve perceptual
% uniformity.
%
% The function can additionally be used to convert a real-valued array into
% a truecolor array using the colormap.
%
% IN:
%   len - Scalar length of the output colormap. If len == Inf the concise
%         table is returned. Default: len = size(get(gcf, 'Colormap'), 1);
%   A - Non-scalar numeric array of real values to be converted into
%       truecolor.
%   lims - 1x2 array of saturation limits to be used on A. Default:
%          [min(A(:)) max(A(:))].
%
% OUT:
%   map - (len)x3 colormap table of RGB values in the range [0,1].
%   B - size(A)x3 truecolor array.

% Copyright: Oliver Woodford, 2015

function map = dawn(varargin)
map = [     0         0         0
       0.0181    0.0021    0.0038
       0.0363    0.0041    0.0076
       0.0528    0.0062    0.0116
       0.0666    0.0082    0.0155
       0.0784    0.0103    0.0194
       0.0890    0.0125    0.0233
       0.0986    0.0146    0.0272
       0.1073    0.0166    0.0312
       0.1153    0.0187    0.0361
       0.1228    0.0208    0.0412
       0.1299    0.0229    0.0459
       0.1365    0.0249    0.0506
       0.1430    0.0269    0.0551
       0.1498    0.0283    0.0595
       0.1568    0.0293    0.0637
       0.1640    0.0297    0.0677
       0.1711    0.0298    0.0725
       0.1783    0.0294    0.0777
       0.1857    0.0285    0.0827
       0.1931    0.0270    0.0876
       0.2007    0.0251    0.0924
       0.2084    0.0230    0.0970
       0.2161    0.0206    0.1017
       0.2237    0.0181    0.1066
       0.2311    0.0157    0.1120
       0.2378    0.0138    0.1186
       0.2444    0.0119    0.1253
       0.2510    0.0097    0.1321
       0.2576    0.0076    0.1390
       0.2641    0.0054    0.1460
       0.2706    0.0032    0.1531
       0.2770    0.0009    0.1603
       0.2833         0    0.1678
       0.2878         0    0.1766
       0.2923         0    0.1855
       0.2967    0.0001    0.1944
       0.3011    0.0007    0.2034
       0.3054    0.0014    0.2125
       0.3096    0.0023    0.2216
       0.3135    0.0037    0.2310
       0.3171    0.0055    0.2404
       0.3193    0.0102    0.2502
       0.3211    0.0160    0.2601
       0.3226    0.0221    0.2701
       0.3239    0.0287    0.2801
       0.3249    0.0361    0.2902
       0.3260    0.0432    0.3003
       0.3268    0.0504    0.3105
       0.3274    0.0573    0.3207
       0.3277    0.0641    0.3310
       0.3279    0.0707    0.3413
       0.3277    0.0772    0.3516
       0.3273    0.0838    0.3620
       0.3266    0.0903    0.3724
       0.3257    0.0967    0.3828
       0.3244    0.1031    0.3932
       0.3229    0.1095    0.4037
       0.3211    0.1158    0.4142
       0.3190    0.1221    0.4247
       0.3165    0.1284    0.4352
       0.3137    0.1347    0.4457
       0.3105    0.1410    0.4562
       0.3070    0.1473    0.4667
       0.3030    0.1535    0.4772
       0.2986    0.1598    0.4877
       0.2938    0.1661    0.4982
       0.2884    0.1724    0.5086
       0.2826    0.1787    0.5190
       0.2763    0.1850    0.5294
       0.2694    0.1913    0.5397
       0.2615    0.1978    0.5497
       0.2529    0.2043    0.5598
       0.2434    0.2108    0.5698
       0.2331    0.2172    0.5799
       0.2238    0.2244    0.5855
       0.2141    0.2316    0.5909
       0.2037    0.2385    0.5963
       0.1927    0.2454    0.6016
       0.1809    0.2523    0.6067
       0.1682    0.2590    0.6117
       0.1544    0.2656    0.6165
       0.1391    0.2722    0.6213
       0.1271    0.2785    0.6243
       0.1161    0.2846    0.6267
       0.1041    0.2907    0.6290
       0.0912    0.2967    0.6312
       0.0767    0.3026    0.6332
       0.0603    0.3085    0.6351
       0.0403    0.3143    0.6369
       0.0174    0.3202    0.6386
       0.0002    0.3258    0.6398
            0    0.3313    0.6404
            0    0.3367    0.6409
            0    0.3421    0.6413
            0    0.3475    0.6417
            0    0.3529    0.6419
            0    0.3582    0.6421
            0    0.3635    0.6422
            0    0.3687    0.6420
            0    0.3738    0.6414
            0    0.3788    0.6408
            0    0.3839    0.6401
            0    0.3889    0.6393
            0    0.3939    0.6385
            0    0.3989    0.6376
            0    0.4039    0.6367
            0    0.4089    0.6358
            0    0.4137    0.6340
            0    0.4184    0.6323
            0    0.4231    0.6306
       0.0043    0.4279    0.6288
       0.0236    0.4325    0.6268
       0.0430    0.4372    0.6248
       0.0599    0.4418    0.6227
       0.0739    0.4464    0.6206
       0.0869    0.4511    0.6184
       0.0987    0.4557    0.6162
       0.1094    0.4603    0.6139
       0.1193    0.4649    0.6116
       0.1285    0.4695    0.6093
       0.1373    0.4741    0.6069
       0.1455    0.4787    0.6045
       0.1533    0.4834    0.6021
       0.1607    0.4880    0.5997
       0.1677    0.4926    0.5973
       0.1744    0.4973    0.5948
       0.1808    0.5019    0.5923
       0.1871    0.5066    0.5898
       0.1925    0.5113    0.5874
       0.1978    0.5160    0.5849
       0.2029    0.5207    0.5825
       0.2079    0.5254    0.5800
       0.2127    0.5301    0.5775
       0.2175    0.5349    0.5749
       0.2220    0.5396    0.5724
       0.2270    0.5443    0.5697
       0.2317    0.5490    0.5670
       0.2364    0.5537    0.5643
       0.2409    0.5584    0.5616
       0.2454    0.5631    0.5589
       0.2503    0.5678    0.5560
       0.2551    0.5725    0.5531
       0.2598    0.5772    0.5502
       0.2644    0.5818    0.5473
       0.2686    0.5866    0.5444
       0.2726    0.5913    0.5415
       0.2767    0.5960    0.5386
       0.2805    0.6008    0.5357
       0.2868    0.6053    0.5323
       0.2932    0.6098    0.5288
       0.2994    0.6143    0.5253
       0.3054    0.6188    0.5218
       0.3113    0.6233    0.5183
       0.3171    0.6278    0.5147
       0.3228    0.6323    0.5112
       0.3283    0.6369    0.5076
       0.3343    0.6413    0.5039
       0.3405    0.6458    0.5001
       0.3465    0.6503    0.4963
       0.3524    0.6547    0.4925
       0.3582    0.6592    0.4886
       0.3639    0.6637    0.4847
       0.3696    0.6682    0.4808
       0.3751    0.6727    0.4769
       0.3809    0.6771    0.4729
       0.3868    0.6816    0.4688
       0.3927    0.6860    0.4647
       0.3985    0.6904    0.4605
       0.4042    0.6949    0.4563
       0.4100    0.6993    0.4521
       0.4157    0.7038    0.4478
       0.4213    0.7082    0.4435
       0.4272    0.7127    0.4391
       0.4335    0.7170    0.4346
       0.4398    0.7213    0.4301
       0.4461    0.7257    0.4255
       0.4524    0.7300    0.4208
       0.4590    0.7343    0.4161
       0.4656    0.7386    0.4114
       0.4722    0.7428    0.4065
       0.4788    0.7471    0.4016
       0.4872    0.7511    0.3967
       0.4955    0.7550    0.3918
       0.5039    0.7589    0.3867
       0.5123    0.7628    0.3817
       0.5207    0.7667    0.3766
       0.5291    0.7706    0.3714
       0.5377    0.7745    0.3662
       0.5463    0.7783    0.3609
       0.5589    0.7812    0.3580
       0.5722    0.7840    0.3559
       0.5855    0.7867    0.3540
       0.5989    0.7893    0.3525
       0.6123    0.7918    0.3514
       0.6257    0.7943    0.3508
       0.6391    0.7967    0.3505
       0.6525    0.7991    0.3508
       0.6660    0.8013    0.3531
       0.6792    0.8035    0.3573
       0.6923    0.8057    0.3619
       0.7051    0.8078    0.3671
       0.7178    0.8100    0.3728
       0.7301    0.8121    0.3790
       0.7423    0.8143    0.3856
       0.7542    0.8165    0.3927
       0.7655    0.8187    0.4008
       0.7757    0.8212    0.4103
       0.7858    0.8237    0.4201
       0.7956    0.8262    0.4300
       0.8052    0.8287    0.4401
       0.8146    0.8313    0.4503
       0.8239    0.8339    0.4606
       0.8331    0.8365    0.4709
       0.8420    0.8392    0.4814
       0.8482    0.8425    0.4937
       0.8545    0.8459    0.5059
       0.8608    0.8492    0.5181
       0.8671    0.8525    0.5302
       0.8728    0.8560    0.5425
       0.8784    0.8595    0.5548
       0.8840    0.8630    0.5670
       0.8896    0.8665    0.5793
       0.8945    0.8702    0.5918
       0.8993    0.8739    0.6043
       0.9040    0.8776    0.6168
       0.9087    0.8814    0.6292
       0.9134    0.8851    0.6417
       0.9180    0.8888    0.6542
       0.9226    0.8926    0.6666
       0.9272    0.8963    0.6791
       0.9312    0.9002    0.6917
       0.9351    0.9042    0.7043
       0.9389    0.9081    0.7170
       0.9427    0.9121    0.7296
       0.9464    0.9160    0.7422
       0.9502    0.9200    0.7549
       0.9539    0.9239    0.7675
       0.9576    0.9279    0.7802
       0.9609    0.9319    0.7929
       0.9639    0.9361    0.8057
       0.9668    0.9403    0.8185
       0.9697    0.9444    0.8314
       0.9726    0.9486    0.8442
       0.9754    0.9528    0.8571
       0.9782    0.9569    0.8699
       0.9809    0.9611    0.8828
       0.9836    0.9653    0.8957
       0.9858    0.9696    0.9087
       0.9881    0.9739    0.9217
       0.9902    0.9782    0.9347
       0.9924    0.9826    0.9477
       0.9944    0.9869    0.9607
       0.9963    0.9912    0.9738
       0.9982    0.9956    0.9869
            1         1         1];
map = colormap_helper(map, varargin{:});