%BONE2  Black-blue-white colormap
%
% Examples:
%   map = bone2;
%   map = bone2(len);
%   B = bone2(A);
%   B = bone2(A, lims);
%
% Similar to MATLAB's bone function, this colormap has been designed to
% achieve perceptual uniformity.
%
% The function can additionally be used to convert a real-valued array into
% a truecolor array using the colormap.
%
% IN:
%   len - Scalar length of the output colormap. If len == Inf the concise
%         table is returned. Default: len = size(get(gcf, 'Colormap'), 1);
%   A - Non-scalar numeric array of real values to be converted into
%       truecolor.
%   lims - 1x2 array of saturation limits to be used on A. Default:
%          [min(A(:)) max(A(:))].
%
% OUT:
%   map - (len)x3 colormap table.
%   B - size(A)x3 truecolor array.

% Copyright: Oliver Woodford, 2015

function map = bone2(varargin)
map = [     0         0         0
       0.0067    0.0051    0.0071
       0.0135    0.0101    0.0143
       0.0202    0.0155    0.0214
       0.0269    0.0205    0.0284
       0.0335    0.0256    0.0357
       0.0403    0.0307    0.0426
       0.0466    0.0360    0.0492
       0.0523    0.0411    0.0550
       0.0577    0.0458    0.0606
       0.0629    0.0504    0.0658
       0.0676    0.0546    0.0707
       0.0721    0.0587    0.0753
       0.0765    0.0626    0.0796
       0.0806    0.0662    0.0839
       0.0846    0.0698    0.0880
       0.0884    0.0732    0.0919
       0.0921    0.0764    0.0956
       0.0955    0.0796    0.0994
       0.0988    0.0827    0.1032
       0.1023    0.0855    0.1071
       0.1059    0.0883    0.1110
       0.1095    0.0910    0.1148
       0.1131    0.0937    0.1188
       0.1168    0.0964    0.1227
       0.1204    0.0992    0.1266
       0.1240    0.1020    0.1307
       0.1276    0.1047    0.1347
       0.1313    0.1075    0.1387
       0.1349    0.1104    0.1428
       0.1386    0.1132    0.1469
       0.1422    0.1160    0.1510
       0.1459    0.1188    0.1551
       0.1495    0.1216    0.1593
       0.1531    0.1245    0.1635
       0.1568    0.1274    0.1677
       0.1604    0.1303    0.1720
       0.1639    0.1332    0.1763
       0.1676    0.1361    0.1805
       0.1712    0.1390    0.1849
       0.1748    0.1420    0.1892
       0.1784    0.1450    0.1936
       0.1819    0.1480    0.1980
       0.1855    0.1509    0.2025
       0.1890    0.1540    0.2070
       0.1924    0.1570    0.2114
       0.1959    0.1600    0.2160
       0.1994    0.1631    0.2205
       0.2029    0.1662    0.2251
       0.2064    0.1693    0.2296
       0.2097    0.1724    0.2343
       0.2129    0.1756    0.2390
       0.2162    0.1788    0.2437
       0.2194    0.1820    0.2485
       0.2227    0.1853    0.2532
       0.2259    0.1885    0.2580
       0.2291    0.1917    0.2628
       0.2322    0.1950    0.2676
       0.2353    0.1983    0.2724
       0.2384    0.2016    0.2773
       0.2414    0.2050    0.2822
       0.2443    0.2084    0.2871
       0.2473    0.2118    0.2920
       0.2501    0.2152    0.2970
       0.2530    0.2186    0.3019
       0.2557    0.2221    0.3069
       0.2585    0.2256    0.3119
       0.2612    0.2291    0.3169
       0.2638    0.2327    0.3219
       0.2664    0.2363    0.3270
       0.2690    0.2398    0.3320
       0.2715    0.2434    0.3371
       0.2740    0.2471    0.3421
       0.2765    0.2507    0.3472
       0.2790    0.2544    0.3523
       0.2813    0.2581    0.3573
       0.2836    0.2618    0.3624
       0.2859    0.2656    0.3675
       0.2882    0.2693    0.3726
       0.2905    0.2731    0.3777
       0.2928    0.2768    0.3828
       0.2951    0.2806    0.3879
       0.2974    0.2844    0.3930
       0.2994    0.2882    0.3981
       0.3014    0.2921    0.4031
       0.3033    0.2961    0.4080
       0.3052    0.3000    0.4130
       0.3070    0.3040    0.4180
       0.3089    0.3080    0.4229
       0.3107    0.3120    0.4278
       0.3124    0.3160    0.4327
       0.3141    0.3201    0.4374
       0.3158    0.3241    0.4421
       0.3175    0.3283    0.4466
       0.3191    0.3324    0.4512
       0.3208    0.3365    0.4556
       0.3224    0.3407    0.4601
       0.3241    0.3449    0.4644
       0.3257    0.3490    0.4687
       0.3275    0.3532    0.4729
       0.3293    0.3574    0.4770
       0.3311    0.3616    0.4809
       0.3330    0.3658    0.4848
       0.3349    0.3700    0.4887
       0.3369    0.3742    0.4925
       0.3389    0.3784    0.4963
       0.3409    0.3826    0.5000
       0.3430    0.3868    0.5037
       0.3452    0.3910    0.5072
       0.3475    0.3952    0.5107
       0.3499    0.3994    0.5141
       0.3523    0.4036    0.5175
       0.3547    0.4078    0.5209
       0.3572    0.4120    0.5242
       0.3597    0.4162    0.5276
       0.3622    0.4204    0.5309
       0.3646    0.4246    0.5343
       0.3670    0.4289    0.5378
       0.3693    0.4331    0.5412
       0.3717    0.4374    0.5447
       0.3741    0.4416    0.5481
       0.3765    0.4459    0.5515
       0.3789    0.4501    0.5550
       0.3813    0.4544    0.5584
       0.3836    0.4587    0.5619
       0.3858    0.4630    0.5655
       0.3880    0.4673    0.5691
       0.3902    0.4717    0.5728
       0.3924    0.4760    0.5764
       0.3946    0.4803    0.5800
       0.3968    0.4846    0.5836
       0.3990    0.4890    0.5872
       0.4013    0.4933    0.5908
       0.4037    0.4977    0.5942
       0.4062    0.5020    0.5976
       0.4087    0.5063    0.6010
       0.4112    0.5106    0.6044
       0.4137    0.5150    0.6078
       0.4163    0.5193    0.6112
       0.4189    0.5236    0.6145
       0.4216    0.5280    0.6178
       0.4247    0.5322    0.6209
       0.4279    0.5365    0.6239
       0.4310    0.5408    0.6269
       0.4342    0.5451    0.6299
       0.4374    0.5494    0.6329
       0.4407    0.5536    0.6359
       0.4439    0.5579    0.6389
       0.4472    0.5622    0.6419
       0.4508    0.5665    0.6447
       0.4544    0.5707    0.6475
       0.4581    0.5749    0.6503
       0.4619    0.5792    0.6531
       0.4657    0.5834    0.6559
       0.4695    0.5876    0.6586
       0.4734    0.5919    0.6614
       0.4773    0.5961    0.6641
       0.4810    0.6004    0.6669
       0.4846    0.6046    0.6697
       0.4883    0.6089    0.6726
       0.4920    0.6132    0.6754
       0.4957    0.6175    0.6782
       0.4994    0.6218    0.6810
       0.5032    0.6261    0.6838
       0.5069    0.6304    0.6866
       0.5106    0.6347    0.6895
       0.5141    0.6391    0.6923
       0.5177    0.6434    0.6952
       0.5213    0.6478    0.6981
       0.5249    0.6521    0.7010
       0.5285    0.6565    0.7039
       0.5321    0.6609    0.7068
       0.5357    0.6652    0.7096
       0.5393    0.6696    0.7125
       0.5429    0.6740    0.7154
       0.5465    0.6784    0.7183
       0.5502    0.6828    0.7212
       0.5538    0.6872    0.7241
       0.5574    0.6916    0.7270
       0.5610    0.6960    0.7299
       0.5646    0.7004    0.7328
       0.5683    0.7048    0.7356
       0.5721    0.7092    0.7385
       0.5759    0.7136    0.7413
       0.5798    0.7180    0.7441
       0.5837    0.7224    0.7469
       0.5876    0.7268    0.7497
       0.5917    0.7312    0.7524
       0.5958    0.7355    0.7551
       0.6000    0.7399    0.7578
       0.6044    0.7442    0.7605
       0.6090    0.7485    0.7631
       0.6137    0.7528    0.7657
       0.6184    0.7570    0.7683
       0.6233    0.7613    0.7709
       0.6283    0.7655    0.7734
       0.6333    0.7697    0.7760
       0.6385    0.7739    0.7786
       0.6439    0.7780    0.7812
       0.6496    0.7821    0.7838
       0.6552    0.7862    0.7864
       0.6610    0.7902    0.7891
       0.6669    0.7943    0.7918
       0.6727    0.7983    0.7945
       0.6787    0.8023    0.7973
       0.6847    0.8063    0.8001
       0.6908    0.8103    0.8029
       0.6970    0.8142    0.8059
       0.7032    0.8181    0.8089
       0.7095    0.8220    0.8119
       0.7158    0.8260    0.8150
       0.7221    0.8299    0.8181
       0.7284    0.8338    0.8213
       0.7348    0.8376    0.8244
       0.7411    0.8415    0.8277
       0.7475    0.8454    0.8310
       0.7539    0.8493    0.8343
       0.7603    0.8531    0.8377
       0.7667    0.8570    0.8411
       0.7732    0.8609    0.8445
       0.7796    0.8647    0.8480
       0.7860    0.8686    0.8515
       0.7925    0.8724    0.8551
       0.7989    0.8763    0.8588
       0.8054    0.8801    0.8626
       0.8118    0.8840    0.8664
       0.8182    0.8878    0.8702
       0.8246    0.8916    0.8741
       0.8311    0.8955    0.8781
       0.8375    0.8993    0.8821
       0.8439    0.9032    0.8861
       0.8502    0.9070    0.8903
       0.8565    0.9109    0.8947
       0.8627    0.9147    0.8991
       0.8690    0.9185    0.9035
       0.8753    0.9224    0.9080
       0.8815    0.9263    0.9124
       0.8878    0.9301    0.9169
       0.8940    0.9340    0.9214
       0.9002    0.9379    0.9260
       0.9064    0.9417    0.9306
       0.9126    0.9456    0.9352
       0.9188    0.9495    0.9398
       0.9251    0.9533    0.9444
       0.9313    0.9572    0.9490
       0.9375    0.9611    0.9536
       0.9438    0.9650    0.9582
       0.9500    0.9689    0.9628
       0.9562    0.9728    0.9674
       0.9625    0.9766    0.9721
       0.9687    0.9805    0.9767
       0.9750    0.9844    0.9814
       0.9812    0.9883    0.9860
       0.9875    0.9922    0.9907
       0.9937    0.9961    0.9953
            1         1         1];
map = colormap_helper(map, varargin{:});