%
%  units_cnsts.m
%
global s ns us ms minute hr ...
    m mm cm km in ft kft nmi Miles ...
    kg deg rad mrad lb g ...
    hz khz mhz ghz thz ...
    knots mph mach rpm w kw deg_K

m     = 1; % distance, meter
kg    = 1; % weight, kilogram
s     = 1; % time, seconds
hz    = 1; % frequency, Hertz
rad   = 1; % angle, radians
w     = 1; % power, watts
deg_K = 1; 

% Time units
ns    = 1.0E-9*s;
us    = 1.0E-6*s;
ms    = 1.0E-3*s;
minute = 60*s;
hr    = 60*minute;

% Weight
lb    = 0.45359237*kg;

% Accelleration due to gravity
g     = 9.80665*m/s/s; % gravity

% Frequency
khz   = 1.0E3 * hz;
mhz   = 1.0E6 * hz;
ghz   = 1.0E9 * hz;
thz   = 1.0E3 * ghz;

% Distance
mm    = 1.0E-3 * m;
cm    = 1.0E-2 * m;
km    = 1.0E3 * m;
ft    = 0.3048 * m;
in    = (1/12.) * ft;
kft   = 1000. * ft;
nmi   = 1852 * m;
Miles = 1.609344 * km;

% Velocity
knots = nmi/hr;
mph   = Miles/hr;
rpm   = 1./minute;
mach  = 331.36 * m/s;

% Anglular units
deg   = pi/180 * rad;
ACP   = deg/(2^14/360);
mrad  = 1.0E-3 * rad;

% Power
kw    = 1.E3 * w;

% Constants

global c k earthRadiusEquatorial earthRadiusPolar

c     = 2.99792458E8 * m/s;     % Speed of light in a vacuum
% c = 2.99705e8 * m/s; % Speed of light in air
k     = 1.38E-23 *w/(hz*deg_K); % Boltzmann's Constant

earthRadiusEquatorial = 6378*km; % imagine.gsfc.nasa.gov
earthRadiusPolar = 6371*km;