function radarstruct = radarStructFromCipMetaData(myRadarObj, dispChan)
% Convert MPDR parameter struct to the OU style to use the GetRadarMoments
% function.
%
%
% INPUTS:
%
% myRadarObj - A MPDR radar object containing CIP meta data and radar
% parameters
%
% OUTPUTS:
%
% radar - Parameters of the radar system
%      delr_m - Range resolution; separates any two range gates
%    noise_dB - Estimates of noise in the measurements. The first value
%               is for the horizontal channel; the second is for vertical
%     calZ_dB - Calibration factors for reflectivity in/out of fill pulse
%      prf_hz - Pulse repetition frequency
%    lambda_m - Carrier wavelength
%   censor_dB - Threshold for SNR censoring
%        date - String representation of date. Only used for plotting
%        time - String representation of time. Only used for plotting
%     fillpad - Number of gates "padding" the pulse fill region
%    fillgate - Number of gates during which the pulse fill is actually
%               being transmitted
%

radarstruct.delr_m = myRadarObj.cipMetaData.rangeCellSize_m(dispChan);

% where does this figure come from? MPS
radarstruct.noise_dB = 22.89; %22.89; 

% not calibrated so I guess 0 is reasonable? MPS
radarstruct.calZ_dB = -25.0 % 0; %-25.0; %-2.0; %-35.0;
radarstruct.prf_hz = 1/myRadarObj.cipMetaData.priTime_s;
radarstruct.lambda_m = myRadarObj.cipMetaData.lambda;

%% censor seems to work? 
radarstruct.censor_dB = 0;
radarstruct.fillpad = 0;
radarstruct.fillgate = 0;

%% new stuff
radarstruct.lr = false;
radarstruct.calZ_dB_SR = 2;
radarstruct.calZ_dB_LR = -25.0;

radarstruct.startOffset_LR =  40;
radarstruct.startOffset_SR = 6;

end
