classdef gpsTrack  < handle
    %gpsTrack class to work with GPS truth data
    %   GPS truth data is downloaded from gps and truth data can be
    %   queeried to match measured data.
    % currently this is a fraction of what it should be... it currently
    % loads a table from excel.  The table was cut and pasted from Garmin
    % Basecamp program, than a macro calculates the distance from the
    % radar.  Equations are copied and values pasted then loaded into
    % matlab.  The matlab creates a time table that is resampled to 30
    % second video frames.  Doing a spline interpulation to fill in the
    % data.  Range rate is calculated in matlab.  Once we have matlab
    % mapping toolbox, we should be able to load the gps files directly...
    % and automate what is a very manual process.
    
    properties
        trackTable;
        trackTT;
        index;
        len;
    end
    
    methods
        function obj = gpsTrack()
            %UNTITLED Construct an instance of this class
            %   Detailed explanation goes here

%             obj.trackTable=readtable(aFileName,'sheet',aSheetName);
            fileName='C:\Users\PaulMartellock\Working\MPDRCalibrationRecordings\mpdr_20210707_Rt8\drive-download-20210712T133932Z-001\Rt8GpsDataTruncated.xlsm';


            sheet.name={ ...
                '2021-07-07 11 36 57',...
                '2021-07-07 11 40 31',...
                '2021-07-07 12 45 30',...
                '2021-07-07 12 48 15',...
                '2021-07-07 13 00 09',...
                '2021-07-07 13 02 13',...
                '2021-07-07 13 15 09',...
                '2021-07-07 13 15 09',...
                '2021-07-07 13 15 09',...
                '2021-07-07 13 15 09'};
            sheet.index=[...
                1056,...
                717,...
                545,...
                255,...
                446,...
                325,...
                296,...
                2065,...
                3731,...
                5363];
            
            ii = 7;
            

            obj.trackTable=readtable(fileName,'sheet',sheet.name{ii});
            obj.index=sheet.index(ii);
            
            obj.trackTable=removevars(obj.trackTable,{'Var2','Elevation',...
                'LegDistance','LegCourse','LegSpeed','Position'});
            obj.trackTT=table2timetable(obj.trackTable,"RowTimes",obj.trackTable.Time);
            dt=seconds(1/30);
            obj.trackTT=retime(obj.trackTT,'regular','spline','TimeStep',dt);
            obj.trackTT.RadialSpeed_mps(:)=0;
            obj.trackTT.RadialSpeed_mps(2:end)=-diff(obj.trackTT.Distance)./...
                seconds(diff(obj.trackTT.Time));
            obj.trackTT.RadialSpeed_mps(1)=obj.trackTT.RadialSpeed_mps(2);
           %todo: remove print...
           vidTime=duration(0,03,35);
            vidTime-(obj.trackTT.Time(6314)-obj.trackTT.Time(sheet.index(7:10)))
            obj.len=length(obj.trackTT.Time);
        end
        
        function [aTime,aRange_m,aRadialSpeed_mps] = getNext(obj)
            %METHOD1 Summary of this method goes here20
            %   Detailed explanation goes here
            obj.index=obj.index+1;
            ii=obj.index;
            if ii <= obj.len
                aTime=obj.trackTT.Time(ii);
                aRange_m=obj.trackTT.Distance(ii);
                aRadialSpeed_mps = obj.trackTT.RadialSpeed_mps(ii);
            end
        end
%         function aRadialVel = getRadialVel(obj,a_InputTime)
%             %TODO FIX...
%            aRadialVel = a_InputTime;
%         end
    end
end

