function MpdrQuickLookNoise(Filename,Pathname)
% MpdrQuickLook(Filenane,Pathname) -- parse a data recording file for MPDR radar
%   filename -- filename of the file to parse

myRadar = mpdrRadar('.\Config\mpdr2RadarConfig.yaml');
if exist('Filename',"var")
    if exist('Pathname',"var")
        myRadar.openDataRecordFile(Filename,Pathname);
    else
        myRadar.openDataRecordFile(Filename);
    end
else
    myRadar.openDataRecordFile();
end

FigOrder=radChan.getFigOrder();
    
% preallocate the cipData ...
myCip=cipCube.factory(myRadar);

[~,eof] = myCip.loadCip();
while ~eof

    myCip.calibrate();
    [cipData,cipMetaData] = myCip.getCipCube();

    %% Plot time domain data
    plotCube(cipData,cipMetaData,...
        ['Time domain complex channels: ' cipMetaData.Filename],'IQ',120);

    %% Plot Magnitude in dBq
    plotCube(cipData,cipMetaData,...
        ['Time domain magnitude channels: ' cipMetaData.Filename],...
        'Mag');

    %%
    chanData=reshape(cipData,cipMetaData.numChannels,[]);
    plotPris=3;
    f3=figure;
    set(f3,'position',[60 70 1500 600]);
    set(f3,'Name',['Noise Histogram: ' cipMetaData.Filename]);
    tiledlayout(4,4);
    for ii=1:8
        nexttile(ii);
        histogram(real(chanData(FigOrder(ii),1:plotPris*cipMetaData.priSize)));
        title([radChan.getString(FigOrder(ii)) ' Real']);
        %     ylim([-plotLimit plotLimit]);
        xlim([-60 60]);
        %     ylabel('dBq');
        xlabel('Samples');
        nexttile(ii+8);
        histogram(imag(chanData(FigOrder(ii),1:plotPris*cipMetaData.priSize)));
        title([radChan.getString(FigOrder(ii)) ' Imag']);
        %     ylim([-plotLimit plotLimit]);
        xlim([-60 60]);
        %     ylabel('dBq');
        xlabel('Samples');
    end
    %%
    
    % RMS noise measurements...
    noise=20*log10(rms((chanData),2));
    f4 = figure;
    set(f4,'position',[100 290 560 420]);
    set(f4,'Name',['RMS Channel Noise Levels: ' cipMetaData.Filename]);
    label=categorical(radChan.getString(FigOrder));
    label=reordercats(label,radChan.getString(FigOrder));
    bar(label,noise(FigOrder));
    ylabel('dBq');
    
    %% measure the DC offset
    biasI=mean(real(chanData),2);
    biasQ=mean(imag(chanData),2);
    figure;
    bar(label,[biasI(FigOrder) biasQ(FigOrder)]);
    ylabel('counts');
    for ii=1:8
        fprintf("%12s I: %f Q: %f \n",label(ii),biasI(FigOrder(ii)),biasQ(FigOrder(ii)));
    end
    keyboard;
    [~,eof] = myCip.loadCip();
end
end