function MpdrQuickLook(Filename,Pathname)
% MpdrQuickLook(Filenane,Pathname) -- parse a data recording file for MPDR radar
%   filename -- filename of the file to parse

myRadar = mpdrRadarFileFread('./Config/mpdr2PlusRadarConfig.yaml');
if exist('Filename',"var")
    if exist('Pathname',"var")  
        myRadar.openDataRecordFile(Filename,Pathname);
    else
        myRadar.openDataRecordFile(Filename);
    end
else
    myRadar.openDataRecordFile();
end

myCip=cipCube.factory(myRadar);
myCip.myTest();

myCip.loadCip();
myCip.calibrate();
[cipData,cipMetaData] = myCip.getCipCube();

%% Plot time domain data
plotCube(cipData,cipMetaData,['Time domain complex channels: ' cipMetaData.Filename],'IQ');

%% Plot Magnitude in dBq
plotCube(cipData,cipMetaData,['Time domain magnitude channels: ' cipMetaData.Filename],'Mag');
%% Plot PC results in dB
myCip.compress();
[cipData,cipMetaData] = myCip.getCipCube();
plotCube(cipData,cipMetaData,['Pulse compressed channels: ' cipMetaData.Filename],'MagDBPeak');
%% 
myRadar.closeFile();
clear f1 ans;
save MpdrQuickLook;
end