function MpdrHeadlessDetections(UDP,MODE, varargin)

Filename = '';
Pathname = '';

%choice = 'SR';
choice = MODE;

% No correction:
yawCorrection = 0; 

% Griffiss test site correction by data collect #.
%yawCorrection = -18.0; % #4
%yawCorrection = -42.0; % #7
%yawCorrection = -60; % #8
%yawCorrection = -94.0; % #9

if( length(varargin) ~= 0 )
% fixme support a fullpath so we don't have to do this goofy dir/file thing? MPS.
    if( length(varargin) == 1 )
        [fPath, fName, fExt] = fileparts(varargin{1});

        Filename = strcat(fName, fExt);
        Pathname = fPath;
        fprintf("filename: %s, pathname: %s\n",Filename,Pathname);
    end
    %fixme 2-args file/path.
end 
% MpdrQuickLook(Filenane,Pathname) -- parse a data recording file for MPDR radar
%   filername -- filename of the file to parse
%UDP = true;
PlotPlot =  false; % switch for adding detection history graphs
PlotPrint = true; % switch for creation of csv file with detections are in
if(UDP)
    RealTimeVideo = false;
    videoFile = false;
    nci=false;                   %non-coherent integration
    PlotPrint = true; 
else
    RealTimeVideo = false;
    videoFile = false;
    nci=false;
    PlotPlot =  false;
    PlotPrint = true;
end
alpha = 1/16; % nci time constant (fraction between zero and one)

radarFile = 'mpdr2PlusRadarConfig.yaml';
% radarFile = 'mpdr2RadarConfig.yaml';
% Fixme -- the mpdr2plusradarconfig vs mpdr2radarconfig_new are very
% different. MPS.  shouldn't mode (Wx vs UAS) be selectable at init not
% determined in file?
%radarFile = 'mpdr2RadarConfig_new.yaml';

myRadar = mpdrRadar(radarFile);


% if(~UDP )
% %    myRadar = mpdrRadar(radarFile);
%     if exist('Filename',"var")
%         if exist('Pathname',"var")
%             myRadar.openDataRecordFile(Filename,Pathname);
%         end
%        else
%            myRadar.openDataRecordFile(Filename);
%        end
%   else
%        myRadar.openDataRecordFile();
%    end
%else
%    myRadar = mpdrRadarUDP(UDPradarFile);
%    %read data from UDP, set up UDP
%    fprintf("ML: Open UDP port\n");
%    myRadar.openUDP();
%end

%myTrack=gpsTrack();

myCip=cipCube.factory(myRadar,UDP,Filename,Pathname);
%load the first CIP...
[cipMetaData,eof] = myCip.loadCip();

% fixme -- 'analysis mode' button. 


% if exist('achoice',"var")
%    fprintf("It exists: %s\n", achoice);
%    choice = achoice;
% end

once = true;
%if(~UDP)
%     if(cipMetaData.wxMode == false )
%         dlgTitle    = 'Long Range / Short Range Selection';
%         dlgQuestion = 'Display LR or SR returns?';
%         choice = questdlg(dlgQuestion,dlgTitle,'LR','SR', 'LR');
%     else
%         choice = 'LR';
%     end
%else
%    choice = 'SR';  % is this because of performance? MPS
%end

% FIXME -- need to process BOTH and use them for
% full extent of our range.  MPS.


%hds determine where channel data is coming from (radChan.sumxr is an enum)
if strcmp(choice,'LR')
   fprintf("LR mode!\n");
    dispChan=uint32(radChan.sumLr);
    %     endRange=cipMetaData.cells.detEnd(dispChan);
    %hds process 8km
    endRange=ceil(15000/cipMetaData.rangeCellSize_m(dispChan)+cipMetaData.cells.rangeZero(dispChan));
else
   fprintf("SR mode!\n");
    dispChan=uint32(radChan.sumSr);
    % process only up to 2.2 km
    endRange=ceil(2200/cipMetaData.rangeCellSize_m(dispChan)+cipMetaData.cells.rangeZero(dispChan));
  %  maxRange=cipMetaData.cells.detEnd(dispChan);
   % fprintf("chan: %d, endRange: %f, maxRange: %f\n", dispChan, endRange, maxRange);
end

fprintf("setting startrange; wxMode: %d\n",cipMetaData.wxMode);

startRange=cipMetaData.cells.rangeZero(dispChan);


if (cipMetaData.wxMode)

    %     scaling=[7 30];
    scaling=[-5 30];
else
    scaling=[8 50];
end

range=[startRange endRange];
fprintf("Range: %f to %f for %s\n", startRange, endRange, choice);
%%  video processing...
% if(videoFile)
%     [~,vidFileName,~]=fileparts(cipMetaData.Filename);
%     vidFileName= sprintf("%s_%s.mp4",vidFileName,radChan.getString(dispChan));
%     %vidfile = VideoWriter(vidFileName,'MPEG-4');
%     vidfile = VideoWriter(vidFileName,'Motion JPEG AVI');
%     vidfile.open();
% end

% range doppler map (the video frame)
%lFig=figure;
%lAxis=gca;
%set(lFig,'position',[20 20 600 800]);
%set(lFig,'Name',['Range Doppler Map ' cipMetaData.Filename]);

%myRangeDopplerMap=rangeDopplerMap(lFig,dispChan,cipMetaData,scaling,range);

% load the next CIP...
deltaTime = 1/30; % default to 30 frames/second;
if nci
    deltaTime = 1/60; % don't skip any data... overlap if necessary
end
frameTime = 0.0;
fprintf("PlotPrint? %d\n", PlotPrint); 

if (PlotPrint)
   fprintf("Got HERE. PLOT PRINT\n");
    try
        csvfid = fopen('./detections_new.csv','w');
        % original output:
        %fprintf(csvfid,"cip,time_s,rangeCell,dopplerCell,Az_deg,snr_db\n");
        % HELIOS 'common' output: adds det index, el (even if 0) and sensor data
        % ID,CIP,LAT,LON,ELE,SNR,VEL,BEAR,RANGE,SYAW,SLAT,SLON,SELE
        fprintf(csvfid, "ID,CIP,LAT,LON,ELE,SNR,VEL,BEAR,RANGE,SYAW,SLAT,SLON,SELE\n");

    catch
        fprintf("can't open plots.csv file: do you  have it open in excel?");
    end
end


cipNum= 1; % 0 first time through loop, >0 thereafter
start=tic;

% FIXME -- need type agnostic loop determination. 
while ~eof  % &&  ((cipNum < cipMetaData.fileSizeCips ))

    %if( cipNum > 60 )
    %    break;
    % end
    
    t1=tic;
    tic;
    myCip.correctDcBias();
    myCip.calibrate();
    myCip.compress();
    e1=toc(t1);t1=tic;
    myCip.dopplerFilter();
    e2=toc(t1);t1=tic;
    myCip.normalize();
    e3=toc(t1);t1=tic;

%    fprintf("calculating using dispChan: %d\n", dispChan );
    plots=myCip.threshold(dispChan); 
    %     plots.range=[];
    %     plots.doppler=[];
    e4=toc(t1);t1=tic;

%     if (PlotPlot)
%         plot(lPpiAxis,plots.dAz_deg,(plots.range*cipMetaData.rangeCellSize_m(dispChan)),'+');
%         xValues = ones(size(plots.range)).* cipNum;
%         plot(lRTa,xValues,(plots.range*cipMetaData.rangeCellSize_m(dispChan)),'+');
%         plot(lDTa,xValues,plots.doppler,'+');
%         plot(lATa,xValues,plots.dAz_deg,'+');
%     end
%fprintf('yawxx: %f\n',cipMetaData.cipCenterAzimuth_d);
syaw = cipMetaData.cipCenterAzimuth_d +yawCorrection;
spitch = cipMetaData.cipCenterElevation_d; % not useful now. maybe for tracking which el slice we're in? MPS

%if( UDP )
    slat = cipMetaData.senslat; %43.1762;
    slon = cipMetaData.senslon; % -75.1385;
%else 
%    slat = 43.1762;
%    slon = -75.1385;
%end
%fprintf("yaw: %f\n",syaw);

    if (PlotPrint)
        %fprintf("sending dets for CIP %d, %d\n", cipNum,size(plots.range)); 

        if( rem(cipNum,10) == 0 )
            	  % if( once )
	     once = false;
	     sensorName = "hmmr";
	     iconColor = 'red';

	       radarIcon='fa-square-o';

	     %		   radarIcon='arrow';
	     ttl=600;
	    % commandstring = sprintf('{"command":{"lat":%f,"lon":%f,"zoom":16}}',slat,slon);
             jsonstring = sprintf('{ "name":"%s","label":"","lat":%f,"lon":%f,"icon":"%s","layer":"sensorlayer","ttl":%d,"color":"%s","mag":2,"iconColor":"%s","bearing":%f,"length":2000}',sensorName,slat,slon, radarIcon, ttl, 'red',iconColor,syaw);
	     %fprintf("String: %s\n",jsonstring);
        %     judp('SEND',7777,'224.0.0.3',int8(commandstring));
	     judp('SEND',7777,'224.0.0.3',int8(jsonstring));
      

	   % end
        end

        if( rem(cipNum,200)==0)
         clearmsg = '{ "command": { "clear":"targetlayer"}}';
         %judp('SEND',7777,'224.0.0.3',int8(clearmsg));
        end

        for ii=1:size(plots.range)
            % not truly 'synth' time just time that we calculated given our
            % primary interval durations.
            cipTime = cipMetaData.priTime_s*cipMetaData.numPris*cipNum;
            % Canned ypr lle for sensor: 25.997,-0.973487,-0.687885,43.1762,-75.1385,302.779

            % CIPMETADATA!  

            %syaw = 30.2; % sensor reading was skewed by 4 degrees?
           
            sele = 0; %302.779; % FIXME
            snr = plots.amp_db(ii);
            vel = cipMetaData.dopplerBins_mps(plots.doppler(ii));
            az = 0; % plots.dAz_deg(ii);
            range = plots.range(ii) * cipMetaData.rangeCellSize_m(dispChan);

           [lat, lon, ele] = matmap3d.aer2geodetic(syaw-az,0, range, slat,slon, 0);


            % TIME too?
            %old format.
            % fprintf(csvfid,"%d,%8.4f,%8.4f,%d,%4.4f,%4.4f\n",cipNum,cipTime,plots.range(ii)*cipMetaData.rangeCellSize_m(dispChan),plots.doppler(ii),plots.dAz_deg(ii),plots.amp_db(ii));
            % Helios 'common' format:
            % ID,CIP,LAT,LON,ELE,SNR,VEL,BEAR,RANGE,SYAW,SLAT,SLON,SELE"

            % better way of doing this? 
            % need to run again without this.  MPS.
	  % if( once )
	     once = false;
	     sensorName = "hmmr";
	     iconColor = 'red';

	       radarIcon='fa-square-o';

	     %		   radarIcon='arrow';
	     ttl=600;
	    % commandstring = sprintf('{"command":{"lat":%f,"lon":%f,"zoom":16}}',slat,slon);
             jsonstring = sprintf('{ "name":"%s","label":"","lat":%f,"lon":%f,"icon":"%s","layer":"sensorlayer","ttl":%d,"color":"%s","mag":2,"iconColor":"%s","bearing":%f,"length":2000}',sensorName,slat,slon, radarIcon, ttl, 'red',iconColor,syaw);
	     %fprintf("String: %s\n",jsonstring);
        %     judp('SEND',7777,'224.0.0.3',int8(commandstring));
	     judp('SEND',7777,'224.0.0.3',int8(jsonstring));
	   % end

%           if( range < 8000) % && abs(vel) > 20 && abs(az) < 3.5 )
                fprintf(csvfid,"%d,%d," + ...   % ID, CIP
                    "%8.4f,%8.4f,%8.4f," + ...  % LAT/LON/ELE
                    "%8.4f,%8.4f,%8.4f,%8.4f," + ... % SNR/VEL/BEAR/RANGE
                    "%8.4f,%8.4f,%8.4f,%8.4f\n", ... % syaw,slat,slon,sele
                    ii, cipNum, ...
                    lat,lon,ele, ...
                    snr,vel,az,range, ...
                    syaw,slat,slon,sele); % SYAW/SLAT/SLON/SELE.  NEED SPITCH,SROLL!

                 uidString = sprintf("%s_%d_%d",choice,cipNum,ii-1);
		 

%		 if( mod(cipNum,10)==0 )
%                       iconString = 'uav';
		 if( choice == 'SR' )
%                   iconString = 'fa-2xs fa-circle-thin';
		   iconString = 'fa-2xs fa-cog';
		 else 
		   iconString='fa-2xs fa-asterisk';
%		      iconString='fa-2xs fa-square-o';
		      %iconString='fa-2xs fa-dot-circle-o';
		 end

                     % iconString = ':black_small_square:';
                     if( vel < 0.0 ) 
			 iconColor = 'cyan';
		     else
		       iconColor = 'yellow';
                     end

                   jsonstring = sprintf('{ "name":"%s","label":"","lat":%f,"lon":%f,"range": %f, "az":%f, "vel":%f,"cipnum":%f,"icon":"%s","layer":"targetlayer","ttl":%d,"color":"%s","mag":2,"iconColor":"%s"}',uidString,lat,lon, range, syaw+az, vel, cipNum, iconString, 600, 'red',iconColor);

                   judp('SEND',7777,'224.0.0.3',int8(jsonstring));
%		 end 

                %need to turn into json message here too for compatibility .
            %end
        end
    end

%     if nci && cipNum > 0
%         [rawCipData,cipMetaData] = myCip.getMagSqCube();
%         cipData = rawCipData.*alpha + cipData.*(1-alpha);
%     else
%         [cipData,cipMetaData] = myCip.getMagSqCube();
%     end
    %     first = false;
    RTPlotInterval = 4;
    %    if ~nci || rem(cipNum,2)==0 % plot even cips when doing nci...
    if ((~UDP && (~nci || (rem(cipNum,2)==0))) || (UDP && rem(cipMetaData.cipNum, RTPlotInterval)==0)) % plot even cips when doing nci..., CIP cips when doing UDP real time video

%        [time_s] = myRangeDopplerMap.plot(lAxis,cipData,cipMetaData,plots, RealTimeVideo);
        %     if (~cipMetaData.wxMode)
        %         [~,aRange_m,aRadialSpeed_mps]=myTrack.getNext( );
        %         hold(lAxis,'on');
        %         plot(lAxis,aRadialSpeed_mps,aRange_m,'md',...
        %             'MarkerSize',20,...
        %             'LineWidth',1.0);
        %     end
        %e5=toc(t1);
%        if(videoFile)
            %  t1=tic;
%            Frame=getframe(lFig);

%            [img,~]=frame2im(Frame);

%            vidfile.writeVideo(img);
%            e6=toc(t1);
%        else
%            drawnow limitrate nocallbacks;
%        end
    end

    % load the next CIP...
    if nci
        deltaTime = 1/60; % don't skip any data... overlap if necessary
    else
        deltaTime = 1/30; % default to 30 frames/second;

    end

    if RealTimeVideo                            %Are we doing this for non-UDP mode? No
        [cipMetaData,eof] = myCip.loadCip(cipNum,deltaTime);
    else
%	fprintf("Loading CIP: %d\n" , cipNum);
	decimate = false;
	if( decimate )
	  cipNum = cipNum +10;
          [cipMetaData,eof] = myCip.loadCip(cipNum,deltaTime); %#ok<UNRCH>
	else
	  [cipMetaData,eof] = myCip.loadCip(cipNum,deltaTime); %#ok<UNRCH>
	  cipNum= cipNum +1;
	end
    end
    etot=toc;
    %     fprintf("%d Radar:%-6.2f Loop:%-6.2f pc:%-6.2f dop:%-6.2f norm:%-6.2f th:%-6.2f plot:%-6.2f vid:%-6.2f \n",...
    %         cipNum,time_s,etot,e1,e2,e3,e4,e5,e6);

end
endTime=toc(start);
avg = endTime/cipNum;
fprintf("Runtime %f Frame Average: %f\n",endTime, avg);
if(videoFile)
    close(vidfile);
end
fclose('all');

end
