function MpdrCubeLook(Filename,Pathname)
% MpdrQuickLook(Filenane,Pathname) -- parse a data recording file for MPDR radar
%   filename -- filename of the file to parse

myRadar = mpdrRadarFileFread('./Config/mpdr2PlusRadarConfig.yaml');

if exist('Filename',"var")
    if exist('Pathname',"var")  
        myRadar.openDataRecordFile(Filename,Pathname);
    else
        myRadar.openDataRecordFile(Filename);
    end
else
    myRadar.openDataRecordFile();
end

myCip=cipCube.factory(myRadar);

% myCip.myTest();

myCip.loadCip();
myCip.calibrate();
[cipData,cipMetaData] = myCip.getCipCube();
% plotCube(cipData,cipMetaData,['Time Domain Mag: ' cipMetaData.Filename],'IQ');
spectrumData=cipData;

LrChans= radChan.getLrChans();
SrChans= radChan.getSrChans();
srPulseLen=cipMetaData.pulseLength_s(uint32(radChan.sumSr))*cipMetaData.sampleRate_sps(uint32(radChan.sumSr));
lrPulseLen=ceil(cipMetaData.pulseLength_s(uint32(radChan.sumLr))*cipMetaData.sampleRate_sps(uint32(radChan.sumLr)));
padding=40;
% plotCube(cipData,cipMetaData,['Time Domain Mag: ' cipMetaData.Filename],'Mag');

% zero out the time after the waveform....
spectrumData(:,(srPulseLen+lrPulseLen+padding):cipMetaData.priSize,:)=complex(0,0);
spectrumData(LrChans,lrPulseLen+padding:cipMetaData.priSize,:)=complex(0,0);
spectrumData(SrChans,1:lrPulseLen-padding,:)=complex(0,0);

plotCube(spectrumData,cipMetaData,['Transmit Time Lr/Sr separated Spectrum: ' cipMetaData.Filename],'Spectrum');


%% pulse compress the data...
myCip.compress();
[pcData,cipMetaData] = myCip.getCipCube();
plotCube(pcData,cipMetaData,['PC processed: ' cipMetaData.Filename],'MagDBPeak');

%% doppler filtering...
myCip.dopplerFilter();
[dopData,cipMetaData] = myCip.getCipCube();
plotCube(dopData,cipMetaData,['PC/Doppler processed: ' cipMetaData.Filename],'MagDBPeak',cipMetaData.numPris);
plotChan(dopData,cipMetaData,radChan.sumLr,['Sum RangeNestedDoppler' cipMetaData.Filename],'MagDBPeak',cipMetaData.numPris);

if ~cipMetaData.wxMode  % can't do this in Wx mode...
    % calculate the CIF...
    % find peak in the DEl channel
    magSqData=myCip.getMagSqCube();
    [~,rangeCell]=max(magSqData(radChan.dElLr,:,myRadar.configVals.clutterCellPeak));
    bgEst= max(magSqData(radChan.dElLr,rangeCell,myRadar.dopplerCells),[],3);
    cif_db = 10*log10(abs(magSqData(radChan.dElLr,rangeCell,myRadar.configVals.clutterCellPeak))/bgEst);
    fprintf("measured CIF %5.2f dB\n", cif_db);
end

%% 
% %% display the range/doppler map
% figure
% hAxes = gca;
% image=abs(dopData(uint32(radChan.sumSr),:,:));
% [~,x,~]=size(image);
% image=reshape(image,x,[]);
% [~] = imagesc(hAxes,20*log10(image));
% set(gcf,'Name',['Range Doppler Map' cipMetaData.Filename]);
% set(gca,'YDir','normal')
% %colormap('jet')
% hcb=colorbar;
% title(hcb,'Power (dB)')
% caxis([30 80])
% % title(['LR Range Doppler Display (CIP #' num2str(cipNum) ', ' sprintf('%5.2f',time_ms/1000) ' sec)'])
% xlabel('Doppler Filter Number')
% ylabel('Range Cell Index')

%% normalize data to rangecell average for the doppler cells (excluding the clutter cells)
myCip.normalize();
[dopData,cipMetaData] = myCip.getMagSqCube();
plotCube(dopData,cipMetaData,['Peak Doppler: ' cipMetaData.Filename],'DopMaxClut',cipMetaData.numPris);

%% display the range/doppler map
figure
hAxes = gca;
dispChan=uint32(radChan.sumSr);
image=abs(dopData(dispChan,cipMetaData.cells.rangeZero(dispChan):end,:));
[~,x,~]=size(image);
image=reshape(image,x,[]);
[~] = imagesc(hAxes,20*log10(image));
set(gcf,'Name',['Range Doppler Map' cipMetaData.Filename]);
set(gca,'YDir','normal')
%colormap('jet')
hcb=colorbar;
title(hcb,'Power (dB)')
caxis([30 80])
% title(['LR Range Doppler Display (CIP #' num2str(cipNum) ', ' sprintf('%5.2f',time_ms/1000) ' sec)'])
xlabel('Doppler Filter Number')
ylabel('Range Cell Index')

% figure(f1);
myRadar.closeFile(); %need to do this before saving the file ...
clear f1 ans;
save MpdrCubeLook;
end
