function MpdrCalcCif(aFilename,aPathname)
% MpdrCalcCif(Filenane,Pathname) -- calculate the clutter improvement
% factor using loopback data


if ~exist('aFilename',"var")
    [aFilename, aPathname]= uigetfile('*.dat',...
        'Select Data-Recording file(s) to process',...
        'multiselect','on');
    if (isfloat(aFilename))
        error('No files selected');
    end
end
if (ischar(aFilename))
    aFilename={aFilename}; % make it always a cell array...
end
meanCif=zeros(1,length(aFilename));

for ii=1:length(aFilename)
    
    myRadar = mpdrRadar('.\Config\mpdr2RadarConfig.yaml');
    myRadar.openDataRecordFile(aFilename{ii},aPathname);
    
    
    myCip=cipCube.factory(myRadar);
    
    % myCip.myTest();
    
    cifSum = 0;
    cipCount = 0;
    
    [~,eof] = myCip.loadCip();
    while ~eof
        myCip.correctDcBias();
        myCip.calibrate();
        myCip.compress();
        myCip.dopplerFilter();
        
        [dopData,cipMetaData] = myCip.getCipCube();
        
        % calculate the CIF...
        % find peak in the DEl channel
        magSqData=myCip.getMagSqCube();
        [~,rangeCell]=max(magSqData(radChan.dElLr,:,myRadar.config.clutterCellPeak));
        bgEst= max(magSqData(radChan.dElLr,rangeCell,myRadar.dopplerCells),[],3);
        cif_db = 10*log10(abs(magSqData(radChan.dElLr,rangeCell,myRadar.config.clutterCellPeak))/bgEst);
        fprintf("measured CIF %5.2f dB\n", cif_db);
        cifSum=cifSum + cif_db;
        cipCount = cipCount + 1;
        [~,eof] = myCip.loadCip();
    end
    meanCif(ii)=cifSum/cipCount;
    fprintf("Average CIF %5.2f dB\n", meanCif(ii));
    dopData=myCip.getMagSqCube();
    plotChan(dopData,cipMetaData,radChan.dElLr,['Peak Doppler: ' cipMetaData.Filename],'DopMaxClut',cipMetaData.numPris);
    clear myRadar myCip;
end
fprintf("\nSummary:\nFilename                             \tCIF(dB)\n");
for ii=1:length(aFilename)
    fprintf("%s\t\t%5.2f dB\n", aFilename{ii},meanCif(ii));
end
end
