% By P. Stockmann (Modified from initial version by D. Mittiga)
% Create a nulled Doppler filter bank with weighting and nulling
% Includes cancellation performance with equipment instability
close all;
clearvar;
set(0,'DefaultAxesFontSize',12)

% Parameters

Tp = 133;   % pulse repetition time in usec
Np = 160;    % number of pulses in a CIP
Nf = Np;    % number of filters (Use at least 2 filters)
Ns = 5;     % number of super clutter filters (odd number)
F = 9500;   % carrier frequency in MHz
Vsll = 40;  % velocity sidelobe weighting (dB)
C = 300;    % speed of light Megameters/sec) 

% Create weighted filters 
dfbank = exp(2i*pi*(0:Np-1)'/Nf*(0:Nf-1))/sqrt(Np);
dfbank1 = exp(2i*pi*(0:Np-1)'/Nf*(0:Nf-1))/sqrt(Np);
cheb = chebwin(Np,Vsll);
cheb1 = chebwin(Np,70);
% cheb1 = ones(1,Np);
% cheb = ones(1,Np)';
%cheb = taylorwin(Np,4,-Vsll);
N0 = fix((Ns -1)/2) ;
dfbank = dfbank.*([ cheb1*ones(1,N0+1) cheb*ones(1,Nf-Ns)  cheb1*ones(1,N0)])/norm(cheb);
%dfbank = dfbank.*(cheb*ones(1,Nf))/norm(cheb);
%dfbank = dfbank.*([cheb1 cheb*ones(1,Nf-1)])/norm(cheb);
 %dfbank(1,:) = dfbank1(1,:).*cheb1;
%dfbank = dfbank./(ones(Np,1)*sqrt(sum(abs(dfbank).^2)));
% 
f = linspace(-0.5,0.5,100000)';
v = f*C*1e6/2/F/Tp;
response = (abs(exp(2i*pi*(-f *(0:Np-1))) * dfbank)).^2;
figure,plot(v,10*log10(response)),grid
xlabel('Velocity (m/s)')
ylabel('Filter Response (dB)')
title('Weighted Filter Bank')
%axis([v(1) v(end) -70 max(max(10*log10(response)))])
axis([v(1) v(end) -70 15])

% Null the weighted filters

Pc = 30; % Clutter power in dB 
% v_mean, and v_sigma in m/s
v_mean = 0; % 
v_sigma = .3; % 
wavelength = C/F;
f_mean = 2 * v_mean / wavelength;
f_sigma = 2 * v_sigma / wavelength;
prf = 1/Tp*1e6;

% Create time diff matrix
dt = reshape(0:Np^2-1,Np,Np);
dt = (floor(dt/Np)-mod(dt,Np)) / prf;
    
% Create the covariance matrix
cov = exp( -2 * pi * dt .* (2*dt*f_sigma.^2 + 1i*f_mean) );
M = 10.^(Pc/10) * cov;
M = M + eye(Np);
% M1 = 10.^(30/10) * cov;
% M1 = M1 + eye(Np);

N0 = fix((Ns -1)/2) ;
dfbank(:,N0+2:end-N0) = M\dfbank(:,N0+2:end-N0);
% dfbank(:,3) = M1\dfbank(:,3);
% dfbank(:,Nf-1) = M1\dfbank(:,Nf-1);
dfbank = dfbank./(ones(Np,1)*sqrt(sum(abs(dfbank).^2)));
% 
f = linspace(-0.5,0.5,10000)';
v = f*C*1e6/2/F/Tp;
response = (abs(exp(2i*pi*(-f *(0:Np-1))) * dfbank(:,N0+2:end-N0))).^2;
figure,plot(v,10*log10(response)),grid
xlabel('Velocity (m/s)')
ylabel('Filter Response (dB)')
title('Weighted and nulled Sub-Clutter Filters')
axis([v(1) v(end) -80 30])

response = (abs(exp(2i*pi*(-f *(0:Np-1))) * dfbank(:,[1:N0+1 end-(N0-1):end]))).^2;
figure,plot(v,10*log10(response)),grid
xlabel('Velocity (m/s)')
ylabel('Filter Response (dB)')
title('Weighted Super Clutter Filters')
axis([v(1) v(end) -80 30])

response = (abs(exp(2i*pi*(-f *(0:Np-1))) * dfbank(:,1:end))).^2;
figure,plot(v,10*log10(response)),grid
xlabel('Velocity (m/s)')
ylabel('Filter Response (dB)')
title('Complete Filter Bank')
axis([v(1) v(end) -80 30])

% 
% Measure filter bank performance
% Clutter power in dB
Pc = 40; 
% v_mean, and v_sigma in m/s
wavelength = C/F;

v_mean = 0;
v_sigma = .4;
f_mean = 2 * v_mean / wavelength;
f_sigma = 2 * v_sigma / wavelength;
prf = 1/Tp*1e6;
% Create time diff matrix
dt = reshape(0:Np^2-1,Np,Np);
dt = (floor(dt/Np)-mod(dt,Np)) / prf;
    
% Create the covariance matrix
cov = exp( -2 * pi * dt .* (2*dt*f_sigma.^2 + 1i*f_mean) );
M = 10.^(Pc/10) * cov;

% Add equipment instabilities 
% crlimitdb = -60;
% crlimit=10^(crlimitdb/10)/(1-10^(crlimitdb/10));
% M=(M+crlimit*diag(diag(M)))/(1+crlimit);

% Add 0 dB noise
M = M + .000001*eye(Np);
M1 = M + eye(Np);

ff = (1e06/Tp)*(C/F)/(2*(Nf));
figure
h=plot((0:Nf-1)*ff,10*log10(diag(abs(dfbank'*(M)*dfbank))),'r',...
(0:Nf-1)*ff,10*log10(diag(abs(dfbank'*(M1)*dfbank))),'b');
%set(h,'Color','k')
set(h,'LineWidth',2)

grid
ylabel('Filter output power (dB)')
xlabel('Velocity (m/sec)')
title('Performance of the Filter Bank ')
legend('C only out','C + N out')
axis([0 (Nf-1)*ff -50 90])

save dfbwts dfbank






