classdef wxCipCube < cipCube
    %wxCipCube -- simplified cipCube focused on Weather Processing Only.
    %   
    
    properties
        null;
    end
    
    methods
        function obj = wxCipCube(myRadar)
            %wxCipCube Construct an instance of this class
            obj=obj@cipCube(myRadar);
            obj.LrChans=[uint32(radChan.sumLr)];
            obj.SrChans=[uint32(radChan.sumSr)];
        end
        function myTest(obj)
            fprintf("wx cube\n");
            obj.cipMetaData
        end
        function [sumPsd,nBurst] = sumMagnitudeRadial(obj,dispChan,sumPsd,nBurst)
            if (nBurst == 0)
                sumPsd = abs(squeeze(obj.dataCube(dispChan,1:size(sumPsd,1),:)));
            else
                sumPsd = sumPsd + abs(squeeze(obj.dataCube(dispChan,1:size(sumPsd,1),:)));
            end
            nBurst = nBurst + 1;
        end
        function [sumPsd,nBurst] = sumPowerRadial2(obj,dispChan,sumPsd,nBurst)
            if (nBurst == 0)
                sumPsd = abs(squeeze(obj.dataCube(dispChan,1:size(sumPsd,1),:))).^2;
            else
                sumPsd = sumPsd + abs(squeeze(obj.dataCube(dispChan,1:size(sumPsd,1),:))).^2;
            end
            nBurst = nBurst + 1;
        end        
        function [sumPsd,nBurst] = sumPowerRadial(obj,dispChan,sumPsd,nBurst)
            if (nBurst == 0)
                sumPsd = squeeze(obj.magSqCube(dispChan,1:size(sumPsd,1),:));
            else
                sumPsd = sumPsd + squeeze(obj.magSqCube(dispChan,1:size(sumPsd,1),:));
            end
            nBurst = nBurst + 1;
        end        
        
    end
end

