classdef (Abstract) radarIO < handle
    %UNTITLED Summary of this class goes here
    %   Detailed explanation goes here

    properties
        %% Define constants to support acquiring data
        cipMetaData; % default values loaded from configuration file
        sourceRadar;
        configFile;
        configVals;
        fileStartLoc;
        rangeCellSize;
        discardPris = 0;
        discardSamples = 0; %number of samples to get to Range 0 LR pulse
        pcTaylorSll = 0; % taylor weighting side lobe level
        pcTaylorNbar = 0; % number of sidelobes for taylor weights
        iQ = 2; % two words per complex sample
        playback=false;
        readSize=0;
        Stc=0;
        StcStartDelay=0;
        stcScale=0;
        seekLoc;
        numClutterCells=0;
        clutterCells; % cells containting clutter
        dopplerCells; % cells which do not contain clutter
        UseMexFileRead = 0;
        RawFileRead =0; % 'original' _u2 type. 
    end
    
    methods
        function obj = radarIO(radarObj)
            %dataCube Construct an instance of this class
            %   Detailed explanation goes here
            obj.configFile=radarObj.configFile;
            obj.configVals=radarObj.configVals;
            obj.discardPris=radarObj.discardPris;
            obj.discardSamples=radarObj.discardSamples;
            obj.pcTaylorSll=radarObj.pcTaylorSll;
            obj.pcTaylorNbar=radarObj.pcTaylorNbar;
            obj.iQ=radarObj.iQ;
            obj.playback=radarObj.playback;
            obj.readSize=radarObj.readSize;
            obj.Stc=radarObj.Stc;
            obj.StcStartDelay=radarObj.StcStartDelay;
            obj.stcScale=radarObj.stcScale;
            obj.seekLoc=radarObj.seekLoc;
            obj.numClutterCells=radarObj.numClutterCells;
            obj.clutterCells=radarObj.clutterCells;
            obj.dopplerCells=radarObj.dopplerCells;
            obj.UseMexFileRead=radarObj.UseMexFileRead;
            obj.RawFileRead=radarObj.RawFileRead;
        end
    end


    methods (Abstract)
        [cipData, cipMetaData, eof] = getCIP(obj,cipData,cipNum,cipTime_s);
    end

    methods(Static)
        function obj=factory(radarObj, UDP, varargin)
            if UDP
                obj = radarIO_UDP(radarObj, varargin{:});
                %obj =radarIO_UDP;
                obj.openUDP(radarObj.cipMetaData.wxMode)
            elseif radarObj.UseMexFileRead
                obj=radarIOFileMex(radarObj, varargin{:});
            elseif radarObj.RawFileRead
                obj=radarIOFileFread(radarObj, varargin{:});
            else
                obj=radarIOPacketFileFread(radarObj, varargin{:});
            end
        end
    end
end
