classdef radConst
    %radConst -- radar constants
    %   common place to keep all constants.
    %   convention: <constant name> "_" si units
    
    properties (Constant)
        dist_m      = 1; % distance, meter
        mass_kg     = 1; % weight, kilogram
        time_s      = 1; % time, seconds
        freq_hz     = 1; % frequency, Hertz
        angle_rad   = 1; % angle, radians
        power_w     = 1; % power, watts
        energy_j    = 1; % energy, joules
        deg_K = 1;
        c_mps = 2.99705e8; % Speed of light in air
        k_JpK = physconst('Boltzmann'); % Boltzmann's constant Joules/degree_K
        earthRadius_m = physconst('EarthRadius'); % polar radius of the earth 

    end

end

