classdef radChan < uint32
    %Radar Channel Enumeration
    %   Specifiy which channel has which data
    %   enumeration values are equal to order data is recorded
    %   


    enumeration
        uasAuxLr(1),
        uasAuxSr(2),
        uasSumSr(3),
        uasSumLr(4),
        uasDElLr(5),
        uasDElSr(6),
        uasDAzSr(7),
        uasDAzLr(8)
    end
    enumeration
        wxAuxLr(1),
        wxAuxSr(2),
        wxSumSr(3),
        wxSumLr(4),
        wxDElLr(5),
        wxDElSr(6),
        wxDAzSr(7),
        wxDAzLr(8)
    end
        
    methods (Static = true)
        function returnWxMode = WxMode(mode)
            persistent wxMode;
            if nargin
                wxMode = mode;
            end
            returnWxMode = wxMode;
        end
            
        function returnString =  getString(arg)
            if radChan.WxMode()
                chanStrings = ["Aux LR",...
                    "Aux SR",...
                    "Sum SR",...
                    "Sum LR",...
                    "Delta El LR",...
                    "Delta El SR",...
                    "Delta Az SR",...
                    "Delta Az LR"];
            else
                chanStrings =[...
                    "Aux LR",...
                    "Aux SR",...
                    "Sum SR",...
                    "Sum LR",...
                    "Delta El LR",...
                    "Delta El SR",...
                    "Delta Az SR",...
                    "Delta Az LR"];
            end
            returnString = chanStrings(arg);
        end
        function out=sumSr()
            if radChan.WxMode()
                out=radChan.wxSumSr;
            else
                out=radChan.uasSumSr;
            end
        end
        function out=sumLr()
            if radChan.WxMode()
                out=radChan.wxSumLr;
            else
                out=radChan.uasSumLr;
            end
        end
        function out=auxSr()
            if radChan.WxMode()
                out=0;
            else
                out=radChan.uasAuxSr;
            end
        end
        function out=auxLr()
            if radChan.WxMode()
                out=0;
            else
                out=radChan.uasAuxLr;
            end
        end
        function out=dAzSr()
            if radChan.WxMode()
                out=0;
            else
                out=radChan.uasDAzSr;
            end
        end
        function out=dAzLr()
            if radChan.WxMode()
                out=0;
            else
                out=radChan.uasDAzLr;
            end
        end
        function out=dElSr()
            if radChan.WxMode()
                out=0;
            else
                out=radChan.uasDElSr;
            end
        end
        function out=dElLr()
            if radChan.WxMode()
                out=0;
            else
                out=radChan.uasDElLr;
            end
        end
            
        function rFigOrder = getFigOrder()
            if radChan.WxMode() 
                rFigOrder = [uint32(radChan.wxSumLr),uint32(radChan.wxSumSr)];
            else
                rFigOrder=[uint32(radChan.uasSumLr),uint32(radChan.uasAuxLr),...
                    uint32(radChan.uasDAzLr),uint32(radChan.uasDElLr),...
                    uint32(radChan.uasSumSr),uint32(radChan.uasAuxSr),...
                    uint32(radChan.uasDAzSr),uint32(radChan.uasDElSr)];
            end
        end
        function rLrChans = getLrChans()
            if radChan.WxMode()
                rLrChans=uint32(radChan.wxSumLr);
            else
                rLrChans=[uint32(radChan.uasSumLr),uint32(radChan.uasAuxLr),...
                    uint32(radChan.uasDAzLr),uint32(radChan.uasDElLr)];
            end
        end
        function rSrChans = getSrChans()
            if radChan.WxMode()
                rSrChans=uint32(radChan.wxSumSr);
            else
                rSrChans=[uint32(radChan.uasSumSr),uint32(radChan.uasAuxSr),...
                    uint32(radChan.uasDAzSr),uint32(radChan.uasDElSr)];
            end
        end
        
        function rSumChans = getSumChans()
            if radChan.WxMode()
                rSumChans = [uint32(radChan.wxSumLr),uint32(radChan.wxSumSr)];
            else
                rSumChans = [uint32(radChan.uasSumLr),uint32(radChan.uasSumSr)];
            end
        end
        function rDazChans = getDazChans()
            rDazChans = [uint32(radChan.uasDAzLr),uint32(radChan.uasDAzSr)];
        end
        function rDelChans = getDelChans()
            rDelChans = [uint32(radChan.uasDElLr),uint32(radChan.uasDElSr)];
        end
        function rAuxChans = getAuxChans()
            rAuxChans = [uint32(radChan.uasAuxLr),uint32(radChan.uasAuxSr)];
        end
    end
end

