function xc = matxcov(A,lag,B)
% matxcov computes the covariance matrix between two matrices (which must be the same size)
%   at the specified lag. If no B matrix is supplied, the A 
%
% Usage:
%   xc = matxcov(A,lag,B)
%
% Inputs:
%   A - First matrix, required
%   lag - the lag between matrices, 0 used if not supplied
%   B - second matrix, optional
%
% Outputs:
%   xc - the cross correlation between the matrices (or autocorrelation of A)
if nargin < 2
    lag = 0;
    B = A;
elseif nargin < 3
    B = A;
end

xc = squeeze(mean(A(:, 1+lag:end) .* conj(B(:, 1:end-lag)), 2));

end
