classdef PulseCompressor
    %PulseCompressor -- pulse compress a waveform.
    %   Each different waveform to be processed needs a different instance
    %   of this class to process it.
    
    properties (GetAccess=public,SetAccess=private)
        Replica = 0;
    end
    
    methods
        function obj = PulseCompressor(WaveformType,bandWidth,pulseWidth,...
                sampleRate,samplesPri,aSll,aNbar)
            %PulseCompressor --  Construct an instance of this class, for
            %each waveform to pulse compress.
            %   create the waveform replica as part of the class
            %   constructor
            if exist('FftwWisdom.mat','file')
                load('FftwWisdom.mat','FftwWisdom');
                if exist("FftwWisdom",'var')
                    fftw('wisdom',FftwWisdom);
                end
            end
            % time vector used to generate ideal pulse
            %% NOTE this allows increased range but at lower res and sensitivity. MPS.
            %pulseWidth=pulseWidth - 0.0000115; %0.0000099
            tVector = -pulseWidth/2:1/sampleRate:pulseWidth/2;
            
            if (WaveformType==waveformTypes.LfmUpChirp)
                LFM = exp(1i*pi*(bandWidth/pulseWidth)*(tVector.^2));
                
%                 wf = figure;
%                 re = real(LFM);
%                 im = imag(LFM);
%                 mag = abs(LFM);
%                 plot(1:size(im,2),im);
%                 hold;
%                 plot(1:size(im,2),re);

            elseif (WaveformType==waveformTypes.LfmDownChirp)                
                LFM = exp(-1*1i*pi*(bandWidth/pulseWidth)*(tVector.^2));
            end
            replica = conj(LFM);

            % optionally apply taylor weighting to the replica.
            if exist('aSll','var')
                if ~exist('aNbar','var')
                    aNbar = 4;
                    %aSll = -110;
                end
                taylorWgts=taylorwin(length(replica),aNbar,aSll);
               
                replica = replica .* taylorWgts';
            end
            % extend array to PRI size with zeros
            zeroArray = zeros(1,int32(samplesPri)-length(replica),'like',replica);
            obj.Replica = cast(fft([replica zeroArray]),'single');
            
        end
        
        function InOutArg = compress(obj,InOutArg)
            %compress -- pulse compress the waveform with the replica
            InOutArg = ifft(fft(InOutArg,[],2).*obj.Replica,[],2);
            %             outputArg = xcorr(obj.Replica,inputArg);
            %
        end
    end
end

