function wtv=wtv_analyze_2b
profile_dir='E:/C17FSR/Wind_Profile_Analysis';
Streamline_data_dir='E:/C17FSR/0714-90/Matfiles';
event_dir='E:/C17FSR/Event';

load('profile_info.mat')
load('wtv_info.mat')
load('event_info.mat')

numprof=length(profile_info);
for j=1:numprof
    time_profile(j)=profile_info(j).time;
end

testday=input('Test day 1-6:  ');
switch testday
    case {1}
        lat0=33+(19+16.73/60)/60;
        lon0=-(114+(22 +32.05/60)/60);
        h0=386.1*100/2.54/12;
    case{2}
        lat0=33+(19+48.09/60)/60;
        lon0=-(114+(22 +31.79/60)/60);
        h0=344.2*100/2.54/12;
    case{3}
        lat0=33+(19+48.43/60)/60;
        lon0=-(114+(22 +31.99/60)/60);
        h0=367.9*100/2.54/12;
    case{4}
        lat0=33+(19+48.47/60)/60;
        lon0=-(114+(22 +32.23/60)/60);
        h0=372.2*100/2.54/12;
    case{5}
        lat0=33+(19+33.01/60)/60;
        lon0=-(114+(22 +14.40/60)/60);
        h0=374.6*100/2.54/12;
    case{6}
        lat0=33+(19+33.16/60)/60;
        lon0=-(114+(22 +13.90/60)/60);
        h0=379.6*100/2.54/12;

end
wtv.lat=lat0;
wtv.lon=lon0;
wtv.height=h0;
        

numofevents=length(event(testday).time_event);

eventnum=input(['Pick event number (1-',num2str(numofevents),'): '])
hv=figure;
hevent=imshow(char(event(testday).file_event(eventnum)))

iind=find(time_profile<event(testday).time_event(eventnum),1,'last')
load(fullfile(profile_dir,char(profile_info(iind).filename)))

iind=find(wtv_time<event(testday).time_event(eventnum),1,'last');
load(char(wtv_files(iind)))
h=fspecial('gaussian',[3 10],.5);
lidar.RWS=imfilter(lidar.RWS,h);
h=fspecial('log',[3 10],.5);
pp=imfilter(lidar.RWS,h);
ind=find(abs(pp)>8);
lidar.RWS(ind)=-999;
lidar.SNR(ind)=-999;

lidar= File_Cleaner_V3(lidar,18,1.005);
scan=scangen_b(lidar,'rhi');
nscans=length(scan);

if nscans>1
    scannum=input(['Pick scan number 1-',num2str(nscans),': ']);
elseif nscans==0
    stop
else
    scannum=1;
end

u=profile.u;
v=profile.v;
AZ=lidar.azimuth(scan(scannum).ind,:);
EL=lidar.elevation(scan(scannum).ind,:);
XD=lidar.xd(scan(scannum).ind,1:end);
YD=lidar.yd(scan(scannum).ind,1:end);
ZD=lidar.zd(scan(scannum).ind,1:end);
RWS=lidar.RWS(scan(scannum).ind,:);
SNR=lidar.SNR(scan(scannum).ind,:);
STARTTIME=mean(lidar.timestamp(scan(scannum).ind));
DECTIME=lidar.lidar_decimal_time(scan(scannum).ind);
RHOD=sqrt(XD.^2+YD.^2);



zh=[0:3:profile.heights(1)];
prof=vvp_regression_RHI(RHOD,ZD,RWS,SNR,lidar.ranges,AZ,EL,zh);

[na,nr]=size(ZD);
uu=prof.rho*sind(AZ(1,1));
vv=prof.rho*cosd(AZ(1,1));
ww=prof.w;
profile.heights=cat(2,prof.heights,profile.heights);
profile.u=cat(1,uu,profile.u);
profile.v=cat(1,vv,profile.v);
profile.w=cat(1,ww,profile.w);

[cm,ii]=min((profile.heights-500).^2);
zh=profile.heights(ii:end);
prof=vvp_regression_RHI(RHOD,ZD,RWS,SNR,lidar.ranges,AZ,EL,zh);

[na,nr]=size(ZD);
uu=prof.rho*sind(AZ(1,1));
vv=prof.rho*cosd(AZ(1,1));
ww=prof.w;
profile.heights(ii:end)=zh;
profile.u(ii:end)=uu;
profile.v(ii:end)=vv;
profile.w(ii:end)=ww;
profile.w(find(abs(profile.w)>6))=0.;
for ja=1:na
  ud=interp1(profile.heights,profile.u,ZD(ja,:),'pchip',0.);
  vd=interp1(profile.heights,profile.v,ZD(ja,:),'pchip',0.);
wd=interp1(profile.heights,profile.w,ZD(ja,:),'pchip',0.); 
  VR(ja,:)=(sind(AZ(ja,1)).*cosd(EL(ja,1)))*ud+(cosd(AZ(ja,1)).*cosd(EL(ja,1)))*vd ...
      + sind(EL(ja,1))*wd;
end
[na,nr]=size(AZ);
RWSeff=RWS-VR;
wtv.AZ=AZ+ones(na,nr)*10.915; %moving to true north
wtv.EL=EL;
wtv.XD=cosd(10.915)*XD-sind(10.915)*YD;
wtv.YD=sind(10.915)*XD+cosd(10.915)*YD;;
wtv.ZD=ZD;
wtv.RWS=RWS;
wtv.RWSeff=RWSeff;
wtv.SNR=SNR;
wtv.STARTTIME=STARTTIME;
wtv.DECTIME=DECTIME;
wtv.RHOD=RHOD;
wtv.pd=sind(AZ).*wtv.XD+cosd(AZ).*wtv.YD;


return