function [xd,zd,UU,WW]=vortex_pair_graphics(wtv)

avgx=(wtv.vortex.port.position(1)+wtv.vortex.starboard.position(1))/2;
avgz=(wtv.vortex.port.position(2)+wtv.vortex.starboard.position(2))/2;

x1=wtv.vortex.port.position(1)-avgx;
x2=wtv.vortex.starboard.position(1)-avgx;
z1=wtv.vortex.port.position(2);
z2=wtv.vortex.starboard.position(2);
zmaxc=max(wtv.vortex.port.core,wtv.vortex.starboard.core);

xmin=x1-max(wtv.vortex.port.core,wtv.vortex.starboard.core)*9;
xmax=x2+max(wtv.vortex.port.core,wtv.vortex.starboard.core)*9;
zmax=max(z1,z2)+9*zmaxc;
zmin=min(z1,z2)-9*zmaxc;

[xd,zd]=meshgrid([xmin:1:xmax],[max(zmin,0):1:zmax]);

xdp=xd-x1;
zdp=zd-z1;

%Left vortex (clockwise rotation)
Xp=complex(xdp,zdp);
        rhop=abs(Xp);
        ang=angle(Xp);
        Vtheta=(1-exp(-1.26*((rhop/wtv.vortex.port.core).^2)))./(2*pi*rhop);
        up=Vtheta.*sin(ang);
        wp=-Vtheta.*cos(ang);
        
UL=up;
WL=wp;

xdp=xd-x2;
zdp=zd-z2;

Xp=complex(xdp,zdp);
        rhop=abs(Xp);
        ang=angle(Xp);
        Vtheta=(1-exp(-1.26*((rhop/wtv.vortex.starboard.core).^2)))./(2*pi*rhop);
        up=-Vtheta.*sin(ang);
        wp=Vtheta.*cos(ang);
        
UR=up;
WR=wp;

UU=wtv.vortex.port.circulation*UL+wtv.vortex.starboard.circulation*UR;
WW=wtv.vortex.port.circulation*WL+wtv.vortex.starboard.circulation*WR;

end