%function vortex_estimate_IMC_ver1_sing(ff)
%Program Description: Vortex_estimate_IMC calculates the optimum center position, angle, and 
%circulation strengths of coupled wingtip vortices using measured Doppler lidar radial
%velocities.
%
%
%
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Select DATA and ROI and retrieve specific scan       %
% wtv is a a strcture with following structures:       %
%   AZ (2D) azimuth (in deg)
%   EL (2D) elevation (in degrees)
%   XD
%   YD
%   ZD
%   RWS
%   RWSeff
%   SNR
%   RHOD
%   pd
%   ROI
%   DECTIME
%   STARTTIME
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% wtv=wtv_analyze_2b();
% passnum=input('enter event number: ');

%load('files.mat')
%load(char(files(100)))
%pass=passnum(100)
%wtv=wtv_analyze_2b();
%passnum=input('enter event number: ');

for jfile=1:length(ff)
    load(char(ff(jfile)));
    [j1,filnm,j2]=fileparts(char(ff(jfile)));
    ppo=findstr(filnm,'_');
    passnum=str2num(filnm(ppo(2)+1:ppo(3)-1));
    RWSeff=wtv.RWSeff;
    
hfig1=figure;
haxe1=axes;
title('Raw Return')
hf=pcolor(wtv.pd,wtv.ZD,wtv.RWSeff);
set(hfig1,'Renderer','ZBuffer')
set(hf,'Edgecolor','none')
caxis([-15 15])
disp('Define ROI')
pntul=getrect(gca);
wtv.ROI=pntul;
rectangle('Position',pntul,'LineWidth',2,'LineStyle','--')
pause(1)

azimuth=mean(wtv.AZ(:,1));
    lat0=wtv.lat;
    lon0=wtv.lon;
    h0=wtv.height;
    daystr=datestr(wtv.STARTTIME,'yyyymmdd');
    [year,month,day,hour,minute,sec]=datevec(wtv.STARTTIME)
    timein=datenum(year,month,day,hour,minute-2,sec);
    timeout=datenum(year,month,day,hour,minute+4,sec);
    [xt_p,yt_p,zt_p,tt_p]=flight_track(lat0,lon0,h0,timein,timeout);

    x1=[wtv.XD(1,200),wtv.YD(1,200),wtv.ZD(1,200)];
    x2=[wtv.XD(30,200),wtv.YD(30,200),wtv.ZD(30,200)];
    if (wtv.EL(30,1)<wtv.EL(1,1))
        x1t=x1;
        x1=x2;
        x2=x1t;
    end
    s1(1)=x1(2)*x2(3)-x1(3)*x2(2);
    s1(2)=x1(3)*x2(2)-x1(2)*x2(3);
    s1(3)=x1(2)*x2(2)-x1(2)*x2(2);
    ss=sqrt(s1(1)^2+s1(2)^2+s1(3)^2);
    s1=s1/ss;

    dd_p=xt_p*s1(1)+yt_p*s1(2);
    %isub=find(abs(dd_p)<2000);

    [junk,ipos]=find(abs(diff(sign(dd_p))));
    [pp,ip]=min(dd_p(ipos));
            
    dy=(yt_p(ipos(ip)+200)-yt_p(ipos(ip)-200));
    dx=(xt_p(ipos(ip)+200)-xt_p(ipos(ip)-200));
    thetaprime=atan2(dy,dx)*180/pi;

    wtv.flight.xt_p=xt_p;
    wtv.flight.yt_p=yt_p;
    wtv.flight.zt_p=zt_p;
    wtv.flight.tt_p=tt_p;
    wtv.flight.Run_in=thetaprime;
    wtv.flight.timeloc=[xt_p(ip);yt_p(ip);zt_p(ip);tt_p(ip)];



[na,nr]=size(wtv.RWS);
R=sqrt(wtv.XD.^2+wtv.YD.^2+wtv.ZD.^2);
wtv.AZ=wtv.AZ;  %-ones(size(wtv.AZ))*thetaprime;
azimuth=mean(wtv.AZ(:,1));
wtv.XD=R.*sind(wtv.AZ).*cosd(wtv.EL);
wtv.YD=R.*cosd(wtv.AZ).*cosd(wtv.EL);
wtv.ZD=R.*sind(wtv.EL);
wtv.pd=sind(wtv.AZ).*wtv.XD+cosd(wtv.AZ).*wtv.YD;

idin=find(wtv.pd>wtv.ROI(1) & wtv.pd<=wtv.ROI(1)+wtv.ROI(3) ...
    & wtv.ZD>wtv.ROI(2) & wtv.ZD<=wtv.ROI(2)+wtv.ROI(4));

% data coordinates in primed system
xp=cosd(thetaprime)*wtv.XD-sind(thetaprime)*wtv.YD;
yp=sind(thetaprime)*wtv.XD+cosd(thetaprime)*wtv.YD;
zp=wtv.ZD;

 set(haxe1,'XLim',[pntul(1),pntul(1)+pntul(3)])
 set(haxe1,'YLim',[pntul(2),pntul(2)+pntul(4)])

% pd1=wtv.vortex.port.position(1);
% pd2=wtv.vortex.starboard.position(1);
% zd1=wtv.vortex.port.position(2);
% zd2=wtv.vortex.port.position(2);

[pd1,zd1]=ginput(1);
pause(1)
[pd2,zd2]=ginput(1);
pause(1)
scatter([pd1 pd2],[zd1 zd2],'ro')
pause(1)
xd1=cosd(thetaprime)*pd1*sind(azimuth)-sind(thetaprime)*pd1*cosd(azimuth);
xd2=cosd(thetaprime)*pd2*sind(azimuth)-sind(thetaprime)*pd2*cosd(azimuth);
yd1=sind(thetaprime)*pd1*sind(azimuth)+cosd(thetaprime)*pd1*cosd(azimuth);
yd2=sind(thetaprime)*pd2*sind(azimuth)+cosd(thetaprime)*pd2*cosd(azimuth);

% position of trial vortex centers in primed coordinates
%xd1=pd1*sind(azimuth-thetaprime);
%xd2=pd2*sind(azimuth-thetaprime);
errmin=1;
SS1=3.0;
SS2=3.0;
sc1=300;
sc2=300.;
down=0.;
nwalk=10000;
npnt=5000;
sca=1;
[Vrm,scale,ee,u,v,w]=vpair_2(1,1.0,SS1,SS2,sc1,xd1,zd1,sc2,xd2,zd2,xp(idin),zp(idin)...
    ,wtv.AZ(idin),wtv.EL(idin),wtv.RWSeff(idin),thetaprime,down);
disp(['starting error:',num2str(ee)])

isc=0;
sca=1.
ipnt=0;
jwalk=0;
disp('Starting Location optimization')
while ipnt<npnt && jwalk<nwalk
    ipnt=ipnt+1;
    jwalk=jwalk+1;
    xd1t=xd1+2*(rand(1,1)-0.5)*5;
    zd1t=zd1+ 2*(rand(1,1)-.5)*5;
    xd2t=xd2+2*(rand(1,1)-0.5)*5;
    zd2t=zd2+2*(rand(1,1)-.5)*5;
    
    [Vrmt,scalet,eet,u,v,w]=vpair_2(1,sca,SS1,SS2,sc1,xd1t,zd1t,sc2,xd2t,zd2t,xp(idin),zp(idin)...
    ,wtv.AZ(idin),wtv.EL(idin),wtv.RWSeff(idin),thetaprime,down);
        if eet>ee
            xd1=xd1t;
            zd1=zd1t;
            xd2=xd2t;
            zd2=zd2t;
            Vrm=Vrmt;
            scale=scalet;
            ee=eet;
            ipnt=1;
        disp([num2str(jwalk),' Correlation/Loc: ',num2str(ee)])
        end
       
end
wtv.vortex.port.position=[xd1/sind(azimuth-thetaprime),zd1];
wtv.vortex.starboard.position=[xd2/sind(azimuth-thetaprime),zd2];
xxt=xd1*sind(azimuth)/sind(azimuth-thetaprime);
yyt=xd1*cosd(azimuth)/sind(azimuth-thetaprime);
zzt=zd1;
[lat,lon,h]=ltp2geo(xxt,yyt,zzt,wtv.lat,wtv.lon,wtv.height);
wtv.vortex.port.gps_position=[lat,lon,h];
xxt=xd2*sind(azimuth)/sind(azimuth-thetaprime);
yyt=xd2*cosd(azimuth)/sind(azimuth-thetaprime);
zzt=zd2;
[lat,lon,h]=ltp2geo(xxt,yyt,zzt,wtv.lat,wtv.lon,wtv.height);
wtv.vortex.starboard.gps_position=[lat*180/pi,lon*180/pi,h];

disp(['Core Locations at: [',num2str(wtv.vortex.port.position(1)),...
    ',',num2str(wtv.vortex.port.position(2)),'] & ['...
    ,num2str(wtv.vortex.starboard.position(1)),','...
    ,num2str(wtv.vortex.starboard.position(2)),']'])
disp(['Correlation:',num2str(ee)])
disp(' ')

ipnt=0;
jwalk=0;
down=0.;
disp('Starting downwash optimization')
while ipnt<npnt && jwalk<nwalk
    ipnt=ipnt+1;
    jwalk=jwalk+1;
    downt=down+2*(rand(1,1)-0.5)*10;
    
    [Vrmt,scalet,eet,u,v,w]=vpair_2(1,sca,SS1,SS2,sc1,xd1,zd1,sc2,xd2,zd2,xp(idin),zp(idin)...
    ,wtv.AZ(idin),wtv.EL(idin),wtv.RWSeff(idin),thetaprime,downt);
        if eet>ee
            down=downt;
            Vrm=Vrmt;
            scale=scalet;
            ee=eet;
            ipnt=1;
        disp([num2str(jwalk),' Correlation/Loc: ',num2str(ee)])
        end
       
end
wtv.vortex.downwash=down;

disp(['Downwash velocity (m): ',num2str(down)])
disp(['Correlation:',num2str(ee)])
disp(' ')


disp('Starting Core Radius optimization')
ipnt=0;
jwalk=0;
while ipnt<npnt && jwalk<nwalk
    ipnt=ipnt+1;
    jwalk=jwalk+1;
    SS1t=SS1+2*(rand(1,1)-.5)*3;
    SS2t=SS2+2*(rand(1,1)-.5)*3;
    [Vrmt,scalet,eet,u,v,w]=vpair_2(1,sca,SS1t,SS2t,sc1,xd1,zd1,sc2,xd2,zd2,xp(idin),zp(idin)...
    ,wtv.AZ(idin),wtv.EL(idin),wtv.RWSeff(idin),thetaprime,down);

        if eet>ee
            SS1=SS1t;
            SS2=SS2t;
            Vrm=Vrmt;
            scale=scalet;
            ee=eet;
            ipnt=1;
        disp([num2str(jwalk),' correlation/Size: ',num2str(ee)])
        end
end
wtv.vortex.port.core=SS1;
wtv.vortex.starboard.core=SS2;
disp(['Left Core Radius: ',num2str(SS1),' - Right Core Radius: ',num2str(SS2)])

disp(['Correlation:',num2str(ee)])
disp(' ')

disp('Starting circulation ratio')
ipnt=0;
jwalk=0;
isc=1;
sca=1.;
[Vrmt,scale,ee,u,v,w]=vpair_2(1,1,SS1,SS2,sc1,xd1,zd1,sc2,xd2,zd2,xp(idin),zp(idin)...
    ,wtv.AZ(idin),wtv.EL(idin),wtv.RWSeff(idin),thetaprime,down);
while ipnt<npnt && jwalk<nwalk
    ipnt=ipnt+1;
    jwalk=jwalk+1;
    sc1t=sc1+2*(rand(1,1)-0.5)*10;
    sc2t=sc2+2*(rand(1,1)-0.5)*10;
    
    [Vrmt,scalet,eet,u,v,w]=vpair_2(1,1,SS1,SS2,sc1t,xd1,zd1,sc2t,xd2,zd2,xp(idin),zp(idin)...
    ,wtv.AZ(idin),wtv.EL(idin),wtv.RWSeff(idin),thetaprime,down);

        if eet>ee
            sc1=sc1t;
            sc2=sc2t;
            ee=eet;
            ipnt=1;
        disp([num2str(jwalk),' correlation/Ratio: ',num2str(ee)])
        end
end
wtv.vortex.port.circulation=sc1;
wtv.vortex.starboard.circulation=sc2;

disp(['Left Circulation: ',num2str(sc1),' - Right Circulation: ',num2str(sc2)])
disp(['Correlation:',num2str(ee)])
disp(' ')
disp(' ')
    [Vrm,scale,ee,u,v,w]=vpair_2(1,1.,SS1,SS2,sc1,xd1,zd1,sc2,xd2,zd2,xp,zp...
    ,wtv.AZ,wtv.EL,wtv.RWSeff,thetaprime,down);
uv=sind(wtv.AZ).*u+cosd(wtv.AZ).*v;

up=cosd(thetaprime)*u-sind(thetaprime)*v;
vp=sind(thetaprime)*v+cosd(thetaprime)*v;
wp=w;



savedir=['F:/C17FSR/event_model_new/',datestr(wtv.STARTTIME,'ddmmmyyyy'),'/pass ',num2str(passnum)]
if ~exist(savedir,'dir')
    mkdir(savedir)
end

hquiv=figure('Position',[1,1,800,600]);

quiver(wtv.pd,wtv.ZD,uv,w)
xlim([wtv.ROI(1) wtv.ROI(1)+wtv.ROI(3)])
ylim([wtv.ROI(2) wtv.ROI(2)+wtv.ROI(4)])

set(gca,'FontName','Arial')
set(gca,'FontSize',12)
xlabel('Cross Range (m)')
ylabel('Height AGL (m)')
tm=datestr(wtv.STARTTIME);
title(['Model ',tm,' Plane Run-in: ',num2str(thetaprime),' Lidar Azimuth: ',num2str(mean(wtv.AZ(idin)))])
filename=fullfile(savedir,['quiver_',datestr(wtv.STARTTIME,'yyyymmdd_HHMMSS'),'.png']);
saveas(hquiv,filename)
% ttm=['quiver_',datestr(wtv.STARTTIME,'yyyymmdd_HHMMSS'),'.mat'];
% filename=fullfile(savedir,ttm);
% save ttm
close(hquiv)
hv=figure('Position',[1,1,800,600])
set(hv,'Renderer','ZBuffer')
kk=pcolor(wtv.pd,wtv.ZD,Vrm);
pdplane=wtv.flight.timeloc(1)*sind(azimuth)+wtv.flight.timeloc(2)*cosd(azimuth);
zdplane=wtv.flight.timeloc(3);
caxis([-15 15])
set(kk,'edgecolor','none')
set(gca,'FontName','Arial')
set(gca,'FontSize',12)
xlabel('Cross Range (m)')
ylabel('Height AGL (m)')
hold on
ks=scatter(pdplane,zdplane,'ro');
set(ks,'SizeData',4^2)
tm=datestr(wtv.STARTTIME);
title(['MODEL ',tm,' Plane Run-in: ',num2str(thetaprime),' Lidar Azimuth: ',num2str(azimuth)])
filename=fullfile(savedir,['Vr_model_',datestr(wtv.STARTTIME,'yyyymmdd_HHMMSS'),'.png']);
saveas(hv,filename)
close(hv)
hwtv=figure('Position',[1,1,800,600]);
set(hwtv,'Renderer','ZBuffer')
hf=pcolor(wtv.pd,wtv.ZD,wtv.RWSeff);
title(['DATA ',tm,' Plane Run-in: ',num2str(thetaprime),' Lidar Azimuth: ',num2str(mean(wtv.AZ(idin))+thetaprime)])
set(hf,'Edgecolor','none')
caxis([-15 15])
set(hf,'edgecolor','none')
set(gca,'FontName','Arial')
set(gca,'FontSize',12)
xlabel('Cross Range (m)')
ylabel('Height AGL (m)')
rectangle('Position',wtv.ROI,'LineWidth',2,'LineStyle','--')
filename=fullfile(savedir,['Vr_data_',datestr(wtv.STARTTIME,'yyyymmdd_HHMMSS'),'.png']);
saveas(hwtv,filename)
close(hwtv)
filename=fullfile(savedir,['vortex',datestr(wtv.STARTTIME,'yyyymmdd_HHMMSS'),'mat']);
save(filename,'wtv')
clear wtv
end