function R=rotct2lg(lat,lon)
% ROTCT2LG  Forms rotation matrix to convert from CT
%   coordinate system to LG (ENU) coordinate system.
%   If astronomic lat,lon input, then output is in
%   local astronomic system. Non-vectorized. See also
%   ROTLG2CT.
% Version: 2011-04-05
% Usage:   R=rotct2lg(lat,lon)
% Input:   lat - lat of local system origin (rad)
%          lon - lon of local system origin (rad)
% Output:  R - Rotation matrix to convert from CT to LG (NEU)

% Copyright (c) 2011, Michael R. Craymer
% All rights reserved.
% Email: mike@craymer.com

if nargin ~= 2
  warning('Incorrect number of input arguments');
  return
end

sinlat=sin(lat);
coslat=cos(lat);
sinlon=sin(lon);
coslon=cos(lon);

R=[ -sinlon          coslon          0
    -sinlat*coslon  -sinlat*sinlon   coslat
     coslat*coslon   coslat*sinlon   sinlat];
