nfiles=length(files)
for j=1:nfiles
    load(char(files(j)));
    [savedir,filnm]=fileparts(char(files(j)));
    hv=figure('Position',[1,1,800,600])
    set(hv,'Renderer','ZBuffer')
    
    tm=datestr(wtv.hittime,'yyyymmdd_HHMMSS');
[xdp,zdp,UU,WW]=vortex_pair_graphics(wtv);
kk=pcolor(xdp,zdp,10*log10((abs(complex(UU,WW))).^2));
    set(kk,'edgecolor','none')
    set(gca,'FontName','Arial')
    set(gca,'FontSize',12)
    xlabel('X (m)')
    ylabel('Z (m)')
    title(['Vortex pair energy density(dB) with velocity ',datestr(wtv.hittime,'yyyymmdd HH:MM:SS'),'  Vortex age (s): ',num2str(wtv.vortex.age)])
    hcb=colorbar;
    hold on
xq=xdp(1:4:end,1:4:end);
zq=zdp(1:4:end,1:4:end);
uq=UU(1:4:end,1:4:end);
wq=WW(1:4:end,1:4:end);
hold on
quiver(xq,zq,uq,wq,'k')
    filename=fullfile(savedir,['vortex_pair_',tm,'.png']);
    saveas(hv,filename)
    pause(1)
    close(hv)
end
