basedir='F:/C17FSR';
datadir='F:/C17FSR/0714-90/Matfiles';
profiledir='F:/C17FSR/Wind_Profile_Analysis';
wtvdir='F:/C17FSR/wtv';

load(fullfile(basedir,'profile.mat'));
%load(fullfile(basedir,'data_file.mat'));
load(fullfile(basedir,'event_timing.mat'));
dl=datenum([0,0,0,0,2,0]);
files=lidar_data.files;
ndata=length(files);
for j=1:ndata
    [path,filnm,ext]=fileparts(char(files(j)));
    data_file(j,:)=[filnm,ext];
end
for j=1:ndata-1
    disp(['file: ',num2str(j),' **',data_file(j,:)])
    tt=fullfile(datadir,data_file(j,:));
    load(tt);
    scan=scangen(lidar,'rhi');
    nscan=length(scan);
    for k=1:nscan
            idin=find(event.timein<=scan(k).scantime & (event.timeout+dl)>=scan(k).scantime);
            if (~isempty(idin))

                wtv.AZ=lidar.azimuth(scan(k).ind,:);
                wtv.EL=lidar.elevation(scan(k).ind,:);
                wtv.XD=lidar.xd(scan(k).ind,:);
                wtv.YD=lidar.yd(scan(k).ind,:);
                wtv.ZD=lidar.zd(scan(k).ind,:);
                wtv.RWS=lidar.RWS(scan(k).ind,:);
                wtv.SNR=lidar.SNR(scan(k).ind,:);
                wtv.Beta=lidar.Beta(scan(k).ind,:);
                wtv.orig_filename=lidar.orig_filename;
                wtv.system_id=lidar.system_id;
                wtv.number_of_gates=lidar.number_of_gates;
                wtv.range_gate_length=lidar.range_gate_length;
                wtv.gatelengthinpts=lidar.gatelengthinpts;
                wtv.pulses_per_ray=lidar.pulses_per_ray;
                wtv.number_of_waypoints=lidar.number_of_waypoints;
                wtv.scan_type=lidar.scan_type;
                wtv.focus_range=lidar.focus_range;
                wtv.start_time=scan(k).scantime;
                wtv.resolution=lidar.resolution;
                wtv.ranges=lidar.ranges;
                wtv.lidar_decimal_time=lidar.lidar_decimal_time(scan(k).ind);
                wtv.timestamp=lidar.timestamp(scan(k).ind);
                wtv.number_of_rays=length(scan(k).ind);
                date=datestr(wtv.start_time,'yyyymmdd_HHMMSS');
                wtv_file=fullfile(wtvdir,[date,'_wtv_event_',num2str(event.id(idin)),'.mat']);
                save(wtv_file,'wtv')
                clear wtv
            end
    end
end

