function [xt,yt,zt,tt]=flight_track(lat0,lon0,h0,timein,timeout)

telem_dir='F:\C17FSR\telemetry';
filename=['nav_',datestr(timein,'yyyymmdd'),'.mat'];

load(fullfile(telem_dir,filename))
ind=find(nav.timestamp>timein & nav.timestamp<timeout);

lat=nav.gps_lat(ind);
lon=nav.gps_lon(ind);
h=nav.gps_alt(ind);
h=h*12*2.54/100;
h0=h0*2.54*12/100;
R=rotct2lg(lat0*pi/180,lon0*pi/180);
[x,y,z]=ell2xyz(lat*pi/180,lon*pi/180,h);
[x0,y0,z0]=ell2xyz(lat0*pi/180,lon0*pi/180,h0);
p0=[x0
    y0
    z0];
p(1,:)=x';
p(2,:)=y';
p(3,:)=z';
a=R*(p-p0*ones(size(x')));
xt=a(1,:);
yt=a(2,:);
zt=a(3,:);
tt=nav.timestamp(ind);
return