function [vad] = File_Cleaner_V3(lidar,Max_Velocity,SNR_CutOff)
% ==================================================================
%
%	MATLAB m-file for Filtering Lidar Data (Radial Velocity, BackScatter)
%				
%				Jason Porter
%				ASU
%			    Dec 2002
%
%	INPUT:	 Data, Header, Sweep ID
%
%	OUTPUT:	 Filtered Data
%
% ========================================================
vad=lidar;
%hard target
[nang,nr]=size(vad.SNR);

% for j=1:nang
%     meanSNR=mean(vad.SNR(j,:));
%     [locs pks]=peakseek(vad.SNR(j,:),5,5*meanSNR);
%     if ~isempty(locs)
%     hard=locs(1);
%         vad.SNR(j,hard:end)=-999;
%     end
% end
[uu,vv]=find(vad.SNR < SNR_CutOff | abs(vad.RWSf) > Max_Velocity);
for j=1:length(uu)
vad.SNR(uu(j),vv(j))=NaN;
vad.RWS(uu(j),vv(j))=NaN;
vad.RWSf(uu(j),vv(j))=NaN;
vad.Beta(uu(j),vv(j))=NaN;
end
% vv=[1:15];
% vad.SNR(:,vv)=NaN;
% vad.RWS(:,vv)=NaN;
% vad.Beta(:,vv)=NaN;
return





