function varargout = Spline(varargin)
% SPLINE MATLAB code for Spline.fig
%      This GUI visualizes the basis functions of spline
%   spaces. Different bases can be chosen from the following:
%
%   1) B-Splines
%   2) Cardinal Splines


% Edit the above text to modify the response to help Spline

% Last Modified by GUIDE v2.5 09-Apr-2014 21:15:44
%%Gentia Zavalani%%

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Spline_OpeningFcn, ...
                   'gui_OutputFcn',  @Spline_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Spline is made visible.
function Spline_OpeningFcn(hObject, eventdata, handles, varargin)
handles.output = hObject;
movegui(hObject,'onscreen')              % To display application onscreen
movegui(hObject,'center')                % To display application in the center of screen    % To check the grid option
handles.Leg = [];                        % Initialize Leg variable for later use
guidata(hObject, handles);

function varargout = Spline_OutputFcn(hObject, eventdata, handles) 

varargout{1} = handles.output;


% --- Executes on selection change in popupmenu1.
function popupmenu1_Callback(hObject, eventdata, handles)

delete(handles.Leg);

handles.Leg = [];    
cla;
if get(handles.popupmenu1,'Value')==1
    set(handles.k,'Enable','On')
    set(handles.na,'String','10')
    set(handles.ini,'String','4')
elseif get(handles.popupmenu1,'Value') == 2
    set(handles.k,'Enable','Off')
    set(handles.na,'String','12')
    set(handles.ini,'String','10')

end
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function popupmenu1_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function ini_Callback(hObject, eventdata, handles)

function ini_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function k_Callback(hObject, eventdata, handles)



% --- Executes during object creation, after setting all properties.
function k_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function na_Callback(hObject, eventdata, handles)

function na_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function plot_Callback(hObject, eventdata, handles)

LegendVar = [];
NoX = 501;
if get(handles.popupmenu1,'value') == 1      % loop for B-Splines
    i = str2num(get(handles.ini,'String'));    % get value of i
    k = str2num(get(handles.k,'String'));    % get value of k
    n = str2num(get(handles.na,'String'));    % get value of n
    if (i+k) > n+1
        msgbox('"i+k" should be less than or equal to "n+1"', ...
            'Warning','None','modal')    
        return
    end
    if i < 1
        msgbox('"i" should be greater than "0"', ...
            'Warning','None','modal')    
        return
    end
    i1 = i; xi = linspace(0,1,n+1); x = linspace(0,1,NoX);
    N = zeros(i,length(x),k);
    for kk = 1:k
        for p = 1:length(x)
            if xi(i1) <= x(p) & xi(i1+1) > x(p)
                N(i1,p,1) = 1;
            end
        end
        i1 = i1+1;
    end
    i1 = i1-2;
    for kk = 2:k
        for ii = i:i1,
             N(ii,:,kk) = ((x-xi(ii))./(xi(ii+kk-1)-xi(ii))).*N(ii,:,kk-1)+ ...
                ((xi(ii+kk)-x)./(xi(ii+kk)-xi(ii+1))).*N(ii+1,:,kk-1);
        end 
        i1 = ii-1;
    end 
    line_pattern = ['   ';'b  ';'g-.';'m-.';'c-.';'r-.';'y-.';'k-.';...
            'bs-';'gs-';'ms-';'cs-';'rs-';'ys-';'ks-';'bd-';'gd-';'rd-';'cd-';'md-';'yd-';'kd-';...
            'bv-';'gv-';'mv-';'cv-';'rv-';'yv-';'kv-';'b<-';'g<-';'r<-';'c<-';'m<-';'y<-';'k<-';...
            'b>-';'g>-';'m>-';'c>-';'r>-';'y>-';'k>-';'bp-';'gp-';'rp-';'cp-';'mp-';'yp-';'kp-';...
            'bh-';'gh-';'mh-';'ch-';'rh-';'yh-';'kh-'];
    
    h = stairs(x,N(i,:,1),':');
    set(h,'LineWidth',1.5)
    legend1(1).text = 'N_is_1';
    hold on

    for ni = 2:k,
        grid on
        plot(x,N(i,:,ni),line_pattern(ni,:),'LineWidth',1.5)
        legend1(ni).text = ['N_is_' num2str(ni)];
    end
    LegendVar = legend(legend1.text);
		set(LegendVar,'FontSize',12);
    axis([0 x(end) -0.05 1.05])
    hold off
    
elseif get(handles.popupmenu1,'Value') == 2       % loop for Cardinal Spline
    n = str2num(get(handles.na,'String'));         % get value of n   
    i = str2num(get(handles.ini,'String'));         % get value of i
    if rem(n,2)~=0
        msgbox('"n" should be an even integer','Warning','None','modal')
        return
    end
    if i > n+2
        msgbox('"i" should be less than or equal to "n+2"','Warning','None','modal')
        return
    end
    if i < 1
        msgbox('"i" should be greater than "0"', ...
            'Warning','None','modal')    
        return
    end
    x = linspace(0, 1, n+1);
    y=zeros(n+3,1); y(i) = 1; xx=0:0.01:1;
    yy=spline(x,y,xx);
    grid on
    plot(xx,yy,'r-','LineWidth',1.5); hold on;
    plot(x,0*x,'k-d','LineWidth',1.5); hold off
    

    set(handles.Display,'XGrid','Off','YGrid','Off','ZGrid','Off') % Make the grid invisible
else 
    set(handles.Display,'XGrid','On','YGrid','On','ZGrid','On')   % Make the grid visible
end
handles.Leg = LegendVar;
guidata(hObject, handles);


% --- Executes on button press in Close.
function Close_Callback(hObject, eventdata, handles)
close(gcbf) % to close GUI


% --- Executes on button press in pushbutton4.
function pushbutton4_Callback(hObject, eventdata, handles)
h = get(gcf,'CurrentAxes');
figure(1);
copyobj(h,gcf);
set(gca,'FontSize',12);
c = copyobj(handles.Leg,gcf);
set(gcf, 'PaperPosition', [2 1 8 4]);
print( gcf, '-depsc2', 'plot.eps' );
close(1);
